/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientProvider;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.UndertowClientMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.FutureResult;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoFuture;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.XnioSsl;

public final class UndertowClient {
    private final Map<String, ClientProvider> clientProviders;
    private static final UndertowClient INSTANCE = new UndertowClient();

    private UndertowClient() {
        this(UndertowClient.class.getClassLoader());
    }

    private UndertowClient(ClassLoader classLoader) {
        ServiceLoader providers = AccessController.doPrivileged(() -> ServiceLoader.load(ClientProvider.class, classLoader));
        HashMap<String, ClientProvider> map = new HashMap<String, ClientProvider>();
        for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                map.put(scheme, provider);
            }
        }
        this.clientProviders = Collections.unmodifiableMap(map);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult(r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, bindAddress, uri, worker, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult(r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, bindAddress, uri, ioThread, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, ioThread, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, ioThread, ssl, bufferPool, options);
    }

    private ClientProvider getClientProvider(URI uri) {
        ClientProvider provider = this.clientProviders.get(uri.getScheme());
        if (provider == null) {
            throw UndertowClientMessages.MESSAGES.unknownScheme(uri);
        }
        return provider;
    }

    public static UndertowClient getInstance() {
        return INSTANCE;
    }

    public static UndertowClient getInstance(ClassLoader classLoader) {
        return new UndertowClient(classLoader);
    }
}

