/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ajp;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientRequest;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientResponse;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientStatistics;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.UndertowClientMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ajp.AjpClientExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ajp.AbstractAjpClientStreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ajp.AjpClientChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ajp.AjpClientRequestClientStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ajp.AjpClientResponseStreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AbstractAttachable;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Protocols;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.Logger;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelExceptionHandler;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.Channels;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;

class AjpClientConnection
extends AbstractAttachable
implements Closeable,
ClientConnection {
    public final ChannelListener<AjpClientRequestClientStreamSinkChannel> requestFinishListener = new ChannelListener<AjpClientRequestClientStreamSinkChannel>(){

        @Override
        public void handleEvent(AjpClientRequestClientStreamSinkChannel channel) {
            if (AjpClientConnection.this.currentRequest != null) {
                AjpClientConnection.this.currentRequest.terminateRequest();
            }
        }
    };
    public final ChannelListener<AjpClientResponseStreamSourceChannel> responseFinishedListener = new ChannelListener<AjpClientResponseStreamSourceChannel>(){

        @Override
        public void handleEvent(AjpClientResponseStreamSourceChannel channel) {
            if (AjpClientConnection.this.currentRequest != null) {
                AjpClientConnection.this.currentRequest.terminateResponse();
            }
        }
    };
    private static final Logger log = Logger.getLogger(AjpClientConnection.class);
    private final Deque<AjpClientExchange> pendingQueue = new ArrayDeque<AjpClientExchange>();
    private AjpClientExchange currentRequest;
    private final OptionMap options;
    private final AjpClientChannel connection;
    private final ByteBufferPool bufferPool;
    private static final int UPGRADED = 0x10000000;
    private static final int UPGRADE_REQUESTED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private int state;
    private final ChannelListener.SimpleSetter<AjpClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final ClientStatistics clientStatistics;
    private final List<ChannelListener<ClientConnection>> closeListeners = new CopyOnWriteArrayList<ChannelListener<ClientConnection>>();

    AjpClientConnection(AjpClientChannel connection, OptionMap options, ByteBufferPool bufferPool, ClientStatistics clientStatistics) {
        this.clientStatistics = clientStatistics;
        this.options = options;
        this.connection = connection;
        this.bufferPool = bufferPool;
        connection.addCloseTask(new ChannelListener<AjpClientChannel>(){

            @Override
            public void handleEvent(AjpClientChannel channel) {
                log.debugf("connection to %s closed", (Object)AjpClientConnection.this.getPeerAddress());
                AjpClientConnection ajpClientConnection = AjpClientConnection.this;
                ajpClientConnection.state = ajpClientConnection.state | Integer.MIN_VALUE;
                ChannelListeners.invokeChannelListener(AjpClientConnection.this, AjpClientConnection.this.closeSetter.get());
                for (ChannelListener listener : AjpClientConnection.this.closeListeners) {
                    listener.handleEvent(AjpClientConnection.this);
                }
                AjpClientExchange pending = (AjpClientExchange)AjpClientConnection.this.pendingQueue.poll();
                while (pending != null) {
                    pending.setFailed(new ClosedChannelException());
                    pending = (AjpClientExchange)AjpClientConnection.this.pendingQueue.poll();
                }
                if (AjpClientConnection.this.currentRequest != null) {
                    AjpClientConnection.this.currentRequest.setFailed(new ClosedChannelException());
                    AjpClientConnection.this.currentRequest = null;
                }
            }
        });
        connection.getReceiveSetter().set(new ClientReceiveListener());
        connection.resumeReceives();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.connection.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends AjpClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.connection.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.connection.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.connection.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.connection.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.connection.setOption(option, value);
    }

    @Override
    public boolean isUpgraded() {
        return Bits.anyAreSet(this.state, 0x30000000);
    }

    @Override
    public boolean isPushSupported() {
        return false;
    }

    @Override
    public boolean isMultiplexingSupported() {
        return false;
    }

    @Override
    public ClientStatistics getStatistics() {
        return this.clientStatistics;
    }

    @Override
    public boolean isUpgradeSupported() {
        return false;
    }

    @Override
    public void addCloseListener(ChannelListener<ClientConnection> listener) {
        this.closeListeners.add(listener);
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        if (Bits.anyAreSet(this.state, -268435456)) {
            clientCallback.failed(UndertowClientMessages.MESSAGES.invalidConnectionState());
            return;
        }
        AjpClientExchange AjpClientExchange2 = new AjpClientExchange(clientCallback, request, this);
        if (this.currentRequest == null) {
            this.initiateRequest(AjpClientExchange2);
        } else {
            this.pendingQueue.add(AjpClientExchange2);
        }
    }

    @Override
    public boolean isPingSupported() {
        return true;
    }

    @Override
    public void sendPing(ClientConnection.PingListener listener, long timeout, TimeUnit timeUnit) {
        this.connection.sendPing(listener, timeout, timeUnit);
    }

    private void initiateRequest(AjpClientExchange AjpClientExchange2) {
        this.currentRequest = AjpClientExchange2;
        ClientRequest request = AjpClientExchange2.getRequest();
        String connectionString = request.getRequestHeaders().getFirst(Headers.CONNECTION);
        if (connectionString != null) {
            if (Headers.CLOSE.equalToString(connectionString)) {
                this.state |= 0x40000000;
            }
        } else if (request.getProtocol() != Protocols.HTTP_1_1) {
            this.state |= 0x40000000;
        }
        if (request.getRequestHeaders().contains(Headers.UPGRADE)) {
            this.state |= 0x20000000;
        }
        long length = 0L;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            length = Long.parseLong(fixedLengthString);
        } else if (transferEncodingString != null) {
            length = -1L;
        }
        AjpClientRequestClientStreamSinkChannel sinkChannel = this.connection.sendRequest(request.getMethod(), request.getPath(), request.getProtocol(), request.getRequestHeaders(), request, this.requestFinishListener);
        this.currentRequest.setRequestChannel(sinkChannel);
        AjpClientExchange2.invokeReadReadyCallback(AjpClientExchange2);
        if (length == 0L) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    this.handleFailedFlush(sinkChannel);
                }
            }
            catch (Throwable t2) {
                this.handleError(t2 instanceof IOException ? (IOException)t2 : new IOException(t2));
            }
        }
    }

    private void handleFailedFlush(AjpClientRequestClientStreamSinkChannel sinkChannel) {
        sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

            @Override
            public void handleException(StreamSinkChannel channel, IOException exception) {
                AjpClientConnection.this.handleError(exception);
            }
        }));
        sinkChannel.resumeWrites();
    }

    private void handleError(IOException exception) {
        this.currentRequest.setFailed(exception);
        IoUtils.safeClose((Closeable)this.connection);
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    public void close() throws IOException {
        log.debugf("close called on connection to %s", (Object)this.getPeerAddress());
        if (Bits.anyAreSet(this.state, Integer.MIN_VALUE)) {
            return;
        }
        this.state |= 0xC0000000;
        this.connection.close();
    }

    public void requestDone() {
        this.currentRequest = null;
        if (Bits.anyAreSet(this.state, 0x40000000)) {
            IoUtils.safeClose((Closeable)this.connection);
        } else if (Bits.anyAreSet(this.state, 0x20000000)) {
            IoUtils.safeClose((Closeable)this.connection);
            return;
        }
        AjpClientExchange next = this.pendingQueue.poll();
        if (next != null) {
            this.initiateRequest(next);
        }
    }

    public void requestClose() {
        this.state |= 0x40000000;
    }

    class ClientReceiveListener
    implements ChannelListener<AjpClientChannel> {
        ClientReceiveListener() {
        }

        @Override
        public void handleEvent(AjpClientChannel channel) {
            block8: {
                try {
                    AbstractAjpClientStreamSourceChannel result = (AbstractAjpClientStreamSourceChannel)channel.receive();
                    if (result == null) {
                        if (!channel.isOpen()) {
                            AjpClientConnection.this.getIoThread().execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (AjpClientConnection.this.currentRequest != null) {
                                        AjpClientConnection.this.currentRequest.setFailed(new ClosedChannelException());
                                    }
                                }
                            });
                        }
                        return;
                    }
                    if (result instanceof AjpClientResponseStreamSourceChannel) {
                        AjpClientResponseStreamSourceChannel response = (AjpClientResponseStreamSourceChannel)result;
                        response.setFinishListener(AjpClientConnection.this.responseFinishedListener);
                        ClientResponse cr = new ClientResponse(response.getStatusCode(), response.getReasonPhrase(), AjpClientConnection.this.currentRequest.getRequest().getProtocol(), response.getHeaders());
                        if (response.getStatusCode() == 100) {
                            AjpClientConnection.this.currentRequest.setContinueResponse(cr);
                        } else {
                            AjpClientConnection.this.currentRequest.setResponseChannel(response);
                            AjpClientConnection.this.currentRequest.setResponse(cr);
                        }
                    } else {
                        Channels.drain(result, Long.MAX_VALUE);
                    }
                }
                catch (Throwable e) {
                    UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                    IoUtils.safeClose((Closeable)AjpClientConnection.this.connection);
                    if (AjpClientConnection.this.currentRequest == null) break block8;
                    AjpClientConnection.this.currentRequest.setFailed(e instanceof IOException ? (IOException)e : new IOException(e));
                }
            }
        }
    }
}

