/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.client.http;

import java.io.IOException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.channels.DetachableStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.channels.DetachableStreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientRequest;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientResponse;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ContinueNotification;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.PushCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.http.HttpClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.http.HttpRequestConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AbstractAttachable;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.Logger;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;

class HttpClientExchange
extends AbstractAttachable
implements ClientExchange {
    private static final Logger log = Logger.getLogger(HttpClientExchange.class.getName());
    private final ClientRequest request;
    private final boolean requiresContinue;
    private final HttpClientConnection clientConnection;
    private ClientCallback<ClientExchange> responseCallback;
    private ClientCallback<ClientExchange> readyCallback;
    private ContinueNotification continueNotification;
    private ClientResponse response;
    private ClientResponse continueResponse;
    private IOException failedReason;
    private HttpRequestConduit requestConduit;
    private int state = 0;
    private static final int REQUEST_TERMINATED = 1;
    private static final int RESPONSE_TERMINATED = 2;

    HttpClientExchange(ClientCallback<ClientExchange> readyCallback, ClientRequest request, HttpClientConnection clientConnection) {
        this.readyCallback = readyCallback;
        this.request = request;
        this.clientConnection = clientConnection;
        boolean reqContinue = false;
        if (request.getRequestHeaders().contains(Headers.EXPECT)) {
            for (String header : request.getRequestHeaders().get(Headers.EXPECT)) {
                if (!header.equals("100-continue")) continue;
                reqContinue = true;
            }
        }
        this.requiresContinue = reqContinue;
    }

    public void setRequestConduit(HttpRequestConduit requestConduit) {
        this.requestConduit = requestConduit;
    }

    void terminateRequest() {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        log.debugf("request terminated for request to %s %s", (Object)this.clientConnection.getPeerAddress(), (Object)this.getRequest().getPath());
        this.state |= 1;
        this.clientConnection.requestDataSent();
        if (Bits.anyAreSet(this.state, 2)) {
            this.clientConnection.exchangeDone();
        }
    }

    boolean isRequestDataSent() {
        return Bits.anyAreSet(this.state, 1);
    }

    void terminateResponse() {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        log.debugf("response terminated for request to %s %s", (Object)this.clientConnection.getPeerAddress(), (Object)this.getRequest().getPath());
        this.state |= 2;
        if (Bits.anyAreSet(this.state, 1)) {
            this.clientConnection.exchangeDone();
        }
    }

    public boolean isRequiresContinue() {
        return this.requiresContinue;
    }

    void setContinueResponse(ClientResponse response) {
        this.continueResponse = response;
        if (this.continueNotification != null) {
            this.continueNotification.handleContinue(this);
        }
    }

    void setResponse(ClientResponse response) {
        this.response = response;
        if (this.responseCallback != null) {
            this.responseCallback.completed(this);
        }
    }

    @Override
    public void setResponseListener(ClientCallback<ClientExchange> listener) {
        this.responseCallback = listener;
        if (listener != null) {
            if (this.failedReason != null) {
                listener.failed(this.failedReason);
            } else if (this.response != null) {
                listener.completed(this);
            }
        }
    }

    @Override
    public void setContinueHandler(ContinueNotification continueHandler) {
        this.continueNotification = continueHandler;
    }

    @Override
    public void setPushHandler(PushCallback pushCallback) {
    }

    void setFailed(IOException e) {
        this.failedReason = e;
        if (this.readyCallback != null) {
            this.readyCallback.failed(e);
            this.readyCallback = null;
        }
        if (this.responseCallback != null) {
            this.responseCallback.failed(e);
            this.responseCallback = null;
        }
        if (this.requestConduit != null) {
            this.requestConduit.freeBuffers();
        }
    }

    @Override
    public StreamSinkChannel getRequestChannel() {
        return new DetachableStreamSinkChannel(this.clientConnection.getConnection().getSinkChannel()){

            @Override
            protected boolean isFinished() {
                return Bits.anyAreSet(HttpClientExchange.this.state, 1);
            }
        };
    }

    @Override
    public StreamSourceChannel getResponseChannel() {
        return new DetachableStreamSourceChannel(this.clientConnection.getConnection().getSourceChannel()){

            @Override
            protected boolean isFinished() {
                return Bits.anyAreSet(HttpClientExchange.this.state, 2);
            }
        };
    }

    @Override
    public ClientRequest getRequest() {
        return this.request;
    }

    @Override
    public ClientResponse getResponse() {
        return this.response;
    }

    @Override
    public ClientResponse getContinueResponse() {
        return this.continueResponse;
    }

    @Override
    public ClientConnection getConnection() {
        return this.clientConnection;
    }

    ClientCallback<ClientExchange> getResponseCallback() {
        return this.responseCallback;
    }

    void invokeReadReadyCallback() {
        if (this.readyCallback != null) {
            this.readyCallback.completed(this);
            this.readyCallback = null;
        }
    }
}

