/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ConduitListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpAttachments;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Attachable;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderValues;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ImmediatePooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitWritableByteChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.Conduits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;

public class ChunkedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    @Deprecated
    public static final AttachmentKey<HeaderMap> TRAILERS = HttpAttachments.RESPONSE_TRAILERS;
    private final HeaderMap responseHeaders;
    private final ConduitListener<? super ChunkedStreamSinkConduit> finishListener;
    private final int config;
    private final ByteBufferPool bufferPool;
    private static final byte[] LAST_CHUNK = new byte[]{48, 13, 10};
    private static final byte[] CRLF = new byte[]{13, 10};
    private final Attachable attachable;
    private int state;
    private int chunkleft = 0;
    private final ByteBuffer chunkingBuffer = ByteBuffer.allocate(12);
    private final ByteBuffer chunkingSepBuffer;
    private PooledByteBuffer lastChunkBuffer;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final int FLAG_WRITES_SHUTDOWN = 1;
    private static final int FLAG_NEXT_SHUTDOWN = 4;
    private static final int FLAG_WRITTEN_FIRST_CHUNK = 8;
    private static final int FLAG_FIRST_DATA_WRITTEN = 16;
    private static final int FLAG_FINISHED = 32;
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public ChunkedStreamSinkConduit(StreamSinkConduit next, ByteBufferPool bufferPool, boolean configurable, boolean passClose, HeaderMap responseHeaders, ConduitListener<? super ChunkedStreamSinkConduit> finishListener, Attachable attachable) {
        super(next);
        this.bufferPool = bufferPool;
        this.responseHeaders = responseHeaders;
        this.finishListener = finishListener;
        this.attachable = attachable;
        this.config = (configurable ? 1 : 0) | (passClose ? 2 : 0);
        this.chunkingSepBuffer = ByteBuffer.allocate(2);
        this.chunkingSepBuffer.flip();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.doWrite(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doWrite(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        if (src.remaining() == 0) {
            return 0;
        }
        this.state |= 0x10;
        int oldLimit = src.limit();
        boolean dataRemaining = false;
        if (this.chunkleft == 0 && !this.chunkingSepBuffer.hasRemaining()) {
            this.chunkingBuffer.clear();
            ChunkedStreamSinkConduit.putIntAsHexString(this.chunkingBuffer, src.remaining());
            this.chunkingBuffer.put(CRLF);
            this.chunkingBuffer.flip();
            this.chunkingSepBuffer.clear();
            this.chunkingSepBuffer.put(CRLF);
            this.chunkingSepBuffer.flip();
            this.state |= 8;
            this.chunkleft = src.remaining();
        } else if (src.remaining() > this.chunkleft) {
            dataRemaining = true;
            src.limit(this.chunkleft + src.position());
        }
        try {
            int chunkingSize = this.chunkingBuffer.remaining();
            int chunkingSepSize = this.chunkingSepBuffer.remaining();
            if (chunkingSize > 0 || chunkingSepSize > 0 || this.lastChunkBuffer != null) {
                long result;
                ByteBuffer[] buf;
                int originalRemaining = src.remaining();
                if (this.lastChunkBuffer == null || dataRemaining) {
                    buf = new ByteBuffer[]{this.chunkingBuffer, src, this.chunkingSepBuffer};
                    result = ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
                } else {
                    buf = new ByteBuffer[]{this.chunkingBuffer, src, this.lastChunkBuffer.getBuffer()};
                    result = Bits.anyAreSet(this.state, 2) ? ((StreamSinkConduit)this.next).writeFinal(buf, 0, buf.length) : ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
                    if (!src.hasRemaining()) {
                        this.state |= 1;
                    }
                    if (!this.lastChunkBuffer.getBuffer().hasRemaining()) {
                        this.state |= 4;
                        this.lastChunkBuffer.close();
                    }
                }
                int srcWritten = originalRemaining - src.remaining();
                this.chunkleft -= srcWritten;
                if (result < (long)chunkingSize) {
                    int n = 0;
                    return n;
                }
                int n = srcWritten;
                return n;
            }
            int result = ((StreamSinkConduit)this.next).write(src);
            this.chunkleft -= result;
            int n = result;
            return n;
        }
        finally {
            src.limit(oldLimit);
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        try {
            if (this.lastChunkBuffer != null) {
                this.lastChunkBuffer.close();
            }
            if (Bits.allAreClear(this.state, 32)) {
                this.invokeFinishListener();
            }
        }
        finally {
            super.truncateWrites();
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            ByteBuffer srcBuffer = srcs[offset + i];
            if (!srcBuffer.hasRemaining()) continue;
            return this.write(srcBuffer);
        }
        return 0L;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            this.terminateWrites();
            return 0;
        }
        if (this.lastChunkBuffer == null) {
            this.createLastChunk(true);
        }
        return this.doWrite(src);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public boolean flush() throws IOException {
        this.state |= 0x10;
        if (Bits.anyAreSet(this.state, 1)) {
            if (Bits.anyAreSet(this.state, 4)) {
                boolean val = ((StreamSinkConduit)this.next).flush();
                if (val && Bits.allAreClear(this.state, 32)) {
                    this.invokeFinishListener();
                }
                return val;
            }
            ((StreamSinkConduit)this.next).write(this.lastChunkBuffer.getBuffer());
            if (!this.lastChunkBuffer.getBuffer().hasRemaining()) {
                this.lastChunkBuffer.close();
                if (Bits.anyAreSet(this.config, 2)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                }
                this.state |= 4;
                boolean val = ((StreamSinkConduit)this.next).flush();
                if (val && Bits.allAreClear(this.state, 32)) {
                    this.invokeFinishListener();
                }
                return val;
            }
            return false;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    private void invokeFinishListener() {
        this.state |= 0x20;
        if (this.finishListener != null) {
            this.finishListener.handleEvent(this);
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        if (!Bits.anyAreSet(this.state, 16)) {
            this.responseHeaders.put(Headers.CONTENT_LENGTH, "0");
            this.responseHeaders.remove(Headers.TRANSFER_ENCODING);
            this.state |= 5;
            try {
                this.flush();
            }
            catch (IOException ignore) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(ignore);
            }
            if (Bits.anyAreSet(this.state, 2)) {
                ((StreamSinkConduit)this.next).terminateWrites();
            }
        } else {
            this.createLastChunk(false);
            this.state |= 1;
            try {
                this.flush();
            }
            catch (IOException ignore) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(ignore);
            }
        }
        if (this.chunkleft != 0) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("Channel closed mid-chunk", new Object[0]);
            ((StreamSinkConduit)this.next).truncateWrites();
        }
    }

    private void createLastChunk(boolean writeFinal) throws UnsupportedEncodingException {
        HeaderMap trailers;
        PooledByteBuffer lastChunkBufferPooled = this.bufferPool.allocate();
        ByteBuffer lastChunkBuffer = lastChunkBufferPooled.getBuffer();
        if (writeFinal) {
            lastChunkBuffer.put(CRLF);
        } else if (this.chunkingSepBuffer.hasRemaining()) {
            lastChunkBuffer.put(this.chunkingSepBuffer);
        }
        lastChunkBuffer.put(LAST_CHUNK);
        HeaderMap attachment = this.attachable.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
        Supplier<HeaderMap> supplier = this.attachable.getAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER);
        if (attachment != null && supplier == null) {
            trailers = attachment;
        } else if (attachment == null && supplier != null) {
            trailers = supplier.get();
        } else if (attachment != null) {
            HeaderMap supplied = supplier.get();
            Iterator<HeaderValues> iterator = supplied.iterator();
            while (iterator.hasNext()) {
                HeaderValues k = iterator.next();
                attachment.putAll(k.getHeaderName(), k);
            }
            trailers = attachment;
        } else {
            trailers = null;
        }
        if (trailers != null && trailers.size() != 0) {
            for (HeaderValues trailer : trailers) {
                for (String val : trailer) {
                    trailer.getHeaderName().appendTo(lastChunkBuffer);
                    lastChunkBuffer.put((byte)58);
                    lastChunkBuffer.put((byte)32);
                    lastChunkBuffer.put(val.getBytes(StandardCharsets.US_ASCII));
                    lastChunkBuffer.put(CRLF);
                }
            }
            lastChunkBuffer.put(CRLF);
        } else {
            lastChunkBuffer.put(CRLF);
        }
        lastChunkBuffer.flip();
        ByteBuffer data = ByteBuffer.allocate(lastChunkBuffer.remaining());
        data.put(lastChunkBuffer);
        data.flip();
        this.lastChunkBuffer = new ImmediatePooledByteBuffer(data);
        lastChunkBufferPooled.close();
    }

    @Override
    public void awaitWritable() throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    private static void putIntAsHexString(ByteBuffer buf, int v) {
        byte int3 = (byte)(v >> 24);
        byte int2 = (byte)(v >> 16);
        byte int1 = (byte)(v >> 8);
        byte int0 = (byte)v;
        boolean nonZeroFound = false;
        if (int3 != 0) {
            buf.put(DIGITS[(0xF0 & int3) >>> 4]).put(DIGITS[0xF & int3]);
            nonZeroFound = true;
        }
        if (nonZeroFound || int2 != 0) {
            buf.put(DIGITS[(0xF0 & int2) >>> 4]).put(DIGITS[0xF & int2]);
            nonZeroFound = true;
        }
        if (nonZeroFound || int1 != 0) {
            buf.put(DIGITS[(0xF0 & int1) >>> 4]).put(DIGITS[0xF & int1]);
        }
        buf.put(DIGITS[(0xF0 & int0) >>> 4]).put(DIGITS[0xF & int0]);
    }
}

