/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.AbstractServerConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitReadableByteChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSourceConduit;

public class ReadDataStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final AbstractServerConnection connection;

    public ReadDataStreamSourceConduit(StreamSourceConduit next, AbstractServerConnection connection) {
        super(next);
        this.connection = connection;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        PooledByteBuffer eb = this.connection.getExtraBytes();
        if (eb != null) {
            ByteBuffer buffer = eb.getBuffer();
            int result = Buffers.copy(dst, buffer);
            if (!buffer.hasRemaining()) {
                eb.close();
                this.connection.setExtraBytes(null);
            }
            return result;
        }
        return super.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        PooledByteBuffer eb = this.connection.getExtraBytes();
        if (eb != null) {
            ByteBuffer buffer = eb.getBuffer();
            int result = Buffers.copy(dsts, offs, len, buffer);
            if (!buffer.hasRemaining()) {
                eb.close();
                this.connection.setExtraBytes(null);
            }
            return result;
        }
        return super.read(dsts, offs, len);
    }

    @Override
    public void resumeReads() {
        if (this.connection.getExtraBytes() != null) {
            this.wakeupReads();
        } else {
            super.resumeReads();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        if (this.connection.getExtraBytes() != null) {
            return;
        }
        super.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (this.connection.getExtraBytes() != null) {
            return;
        }
        super.awaitReadable(time, timeUnit);
    }
}

