/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class ExistsPredicate
implements Predicate {
    private final ExchangeAttribute attribute;

    ExistsPredicate(ExchangeAttribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String att = this.attribute.readAttribute(value);
        if (att == null) {
            return false;
        }
        return !att.isEmpty();
    }

    public String toString() {
        return "exists( '" + this.attribute.toString() + "' )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "exists";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", ExchangeAttribute.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute value = (ExchangeAttribute)config.get("value");
            return new ExistsPredicate(value);
        }
    }
}

