/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.PathMatcher;

public class PathPrefixPredicate
implements Predicate {
    public static final String PREFIX_MATCH_RECORD = "PREFIX_MATCH_RECORD";
    private final PathMatcher<Boolean> pathMatcher;
    private static final boolean traceEnabled = UndertowLogger.PREDICATE_LOGGER.isTraceEnabled();

    PathPrefixPredicate(String ... paths) {
        PathMatcher<Boolean> matcher = new PathMatcher<Boolean>();
        for (String path : paths) {
            if (!path.startsWith("/")) {
                matcher.addPrefixPath("/" + path, Boolean.TRUE);
                continue;
            }
            matcher.addPrefixPath(path, Boolean.TRUE);
        }
        this.pathMatcher = matcher;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        PathMatcher.PathMatch<Boolean> result = this.pathMatcher.match(relativePath);
        boolean matches = Boolean.TRUE.equals(result.getValue());
        if (traceEnabled) {
            UndertowLogger.PREDICATE_LOGGER.tracef("Path prefix(s) [%s] %s input [%s] for %s.", this.pathMatcher.getPathMatchesSet().stream().collect(Collectors.joining(", ")), matches ? "MATCH" : "DO NOT MATCH", relativePath, value);
        }
        if (matches) {
            TreeMap<String, String> context = (TreeMap<String, String>)value.getAttachment(PREDICATE_CONTEXT);
            if (context == null) {
                context = new TreeMap<String, String>();
                value.putAttachment(PREDICATE_CONTEXT, context);
            }
            if (traceEnabled && result.getRemaining().length() > 0) {
                UndertowLogger.PREDICATE_LOGGER.tracef("Storing \"remaining\" string of [%s] for %s.", (Object)result.getRemaining(), (Object)value);
            }
            context.put("remaining", result.getRemaining());
            PathPrefixMatchRecord transformer = new PathPrefixMatchRecord();
            transformer.setRemaining(result.getRemaining());
            transformer.setPrefix(result.getMatched());
            context.put(PREFIX_MATCH_RECORD, (String)((Object)transformer));
        }
        return matches;
    }

    public String toString() {
        Set<String> matches = this.pathMatcher.getPathMatchesSet();
        if (matches.size() == 1) {
            return "path-prefix( '" + matches.toArray()[0] + "' )";
        }
        return "path-prefix( { '" + matches.stream().collect(Collectors.joining("', '")) + "' } )";
    }

    public static class PathPrefixMatchRecord {
        private String prefix;
        private String remaining;
        private boolean overWritten;

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setRemaining(String remaining) {
            this.remaining = remaining;
        }

        public void overWritten() {
            this.overWritten = true;
        }

        public boolean isOverWritten() {
            return this.overWritten;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getRemaining() {
            return this.remaining;
        }
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-prefix";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path = (String[])config.get("path");
            return new PathPrefixPredicate(path);
        }
    }
}

