/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;

public class RequestSmallerThanPredicate
implements Predicate {
    private final long size;

    RequestSmallerThanPredicate(long size) {
        this.size = size;
    }

    @Override
    public boolean resolve(HttpServerExchange exchange) {
        String length = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (length == null) {
            return false;
        }
        return Long.parseLong(length) < this.size;
    }

    public String toString() {
        return "request-smaller-than( '" + this.size + "' )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "request-smaller-than";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("size", Long.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("size");
        }

        @Override
        public String defaultParameter() {
            return "size";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            Long size = (Long)config.get("size");
            return new RequestSmallerThanPredicate(size);
        }
    }
}

