/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.alpn;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLEngine;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.alpn.ALPNProvider;

public class OpenSSLAlpnProvider
implements ALPNProvider {
    private static volatile OpenSSLALPNMethods openSSLALPNMethods;
    private static volatile boolean initialized;
    public static final String OPENSSL_ENGINE = "net.thisptr.jmx.exporter.agent.shade.org.wildfly.openssl.OpenSSLEngine";

    @Override
    public boolean isEnabled(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().equals(OPENSSL_ENGINE) && OpenSSLAlpnProvider.getOpenSSLAlpnMethods() != null;
    }

    @Override
    public SSLEngine setProtocols(SSLEngine engine, String[] protocols) {
        try {
            OpenSSLAlpnProvider.getOpenSSLAlpnMethods().setApplicationProtocols().invoke((Object)engine, new Object[]{protocols});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return engine;
    }

    @Override
    public String getSelectedProtocol(SSLEngine engine) {
        try {
            return (String)OpenSSLAlpnProvider.getOpenSSLAlpnMethods().getApplicationProtocol().invoke((Object)engine, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OpenSSLALPNMethods getOpenSSLAlpnMethods() {
        if (initialized) return openSSLALPNMethods;
        Class<OpenSSLAlpnProvider> clazz = OpenSSLAlpnProvider.class;
        synchronized (OpenSSLAlpnProvider.class) {
            if (initialized) return openSSLALPNMethods;
            openSSLALPNMethods = AccessController.doPrivileged(new PrivilegedAction<OpenSSLALPNMethods>(){

                @Override
                public OpenSSLALPNMethods run() {
                    try {
                        Class<?> openSSLEngine = Class.forName(OpenSSLAlpnProvider.OPENSSL_ENGINE, true, OpenSSLAlpnProvider.class.getClassLoader());
                        Method setApplicationProtocols = openSSLEngine.getMethod("setApplicationProtocols", String[].class);
                        Method getApplicationProtocol = openSSLEngine.getMethod("getSelectedApplicationProtocol", new Class[0]);
                        UndertowLogger.ROOT_LOGGER.debug("OpenSSL ALPN Enabled");
                        return new OpenSSLALPNMethods(setApplicationProtocols, getApplicationProtocol);
                    }
                    catch (Throwable e) {
                        UndertowLogger.ROOT_LOGGER.debug("OpenSSL ALPN disabled", e);
                        return null;
                    }
                }
            });
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return openSSLALPNMethods;
        }
    }

    @Override
    public int getPriority() {
        return 400;
    }

    public String toString() {
        return "OpenSSLAlpnProvider";
    }

    public static class OpenSSLALPNMethods {
        private final Method setApplicationProtocols;
        private final Method getApplicationProtocol;

        OpenSSLALPNMethods(Method setApplicationProtocols, Method getApplicationProtocol) {
            this.setApplicationProtocols = setApplicationProtocols;
            this.getApplicationProtocol = getApplicationProtocol;
        }

        public Method getApplicationProtocol() {
            return this.getApplicationProtocol;
        }

        public Method setApplicationProtocols() {
            return this.setApplicationProtocols;
        }
    }
}

