/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2;

import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.ConnectionErrorException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2FrameHeaderParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2PushBackParser;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;

class Http2DataFrameParser
extends Http2PushBackParser {
    private int padding = 0;

    Http2DataFrameParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser headerParser) throws ConnectionErrorException {
        if (Bits.anyAreClear(headerParser.flags, 8)) {
            this.finish();
            return;
        }
        if (headerParser.length == 0) {
            throw new ConnectionErrorException(1);
        }
        if (resource.remaining() > 0) {
            this.padding = resource.get() & 0xFF;
            --headerParser.length;
            if (this.padding > headerParser.length) {
                throw new ConnectionErrorException(1);
            }
            this.finish();
        }
    }

    int getPadding() {
        return this.padding;
    }
}

