/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.AbstractHttp2StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Channel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.framed.SendFrameHeader;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;

public abstract class Http2StreamSinkChannel
extends AbstractHttp2StreamSinkChannel {
    private final int streamId;
    private volatile boolean reset = false;
    private int flowControlWindow;
    private int initialWindowSize;
    private SendFrameHeader header;
    private final Object flowControlLock = new Object();

    Http2StreamSinkChannel(Http2Channel channel, int streamId) {
        super(channel);
        this.streamId = streamId;
        this.initialWindowSize = this.flowControlWindow = channel.getInitialSendWindowSize();
    }

    public int getStreamId() {
        return this.streamId;
    }

    SendFrameHeader generateSendFrameHeader() {
        this.header = this.createFrameHeaderImpl();
        return this.header;
    }

    protected abstract SendFrameHeader createFrameHeaderImpl();

    void clearHeader() {
        this.header = null;
    }

    @Override
    protected void channelForciblyClosed() throws IOException {
        ((Http2Channel)this.getChannel()).removeStreamSink(this.getStreamId());
        if (this.reset) {
            return;
        }
        this.reset = true;
        if (this.streamId % 2 == (((Http2Channel)this.getChannel()).isClient() ? 1 : 0)) {
            if (this.isFirstDataWritten() && !((Http2Channel)this.getChannel()).isThisGoneAway()) {
                ((Http2Channel)this.getChannel()).sendRstStream(this.streamId, 8);
            }
        } else if (!((Http2Channel)this.getChannel()).isThisGoneAway()) {
            ((Http2Channel)this.getChannel()).sendRstStream(this.streamId, 5);
        }
        this.markBroken();
    }

    @Override
    protected final SendFrameHeader createFrameHeader() {
        SendFrameHeader header = this.header;
        this.header = null;
        return header;
    }

    @Override
    protected void handleFlushComplete(boolean channelClosed) {
        if (channelClosed) {
            ((Http2Channel)this.getChannel()).removeStreamSink(this.getStreamId());
        }
        if (this.reset) {
            IoUtils.safeClose((Closeable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int grabFlowControlBytes(int toSend) {
        Object object = this.flowControlLock;
        synchronized (object) {
            if (toSend == 0) {
                return 0;
            }
            int newWindowSize = ((Http2Channel)this.getChannel()).getInitialSendWindowSize();
            int settingsDelta = newWindowSize - this.initialWindowSize;
            if (settingsDelta != 0) {
                this.initialWindowSize = newWindowSize;
                this.flowControlWindow += settingsDelta;
                this.flowControlLock.notifyAll();
            }
            int min2 = Math.min(toSend, this.flowControlWindow);
            int actualBytes = ((Http2Channel)this.getChannel()).grabFlowControlBytes(min2);
            this.flowControlWindow -= actualBytes;
            return actualBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFlowControlWindow(int delta) throws IOException {
        boolean exhausted;
        Object object = this.flowControlLock;
        synchronized (object) {
            exhausted = this.flowControlWindow <= 0;
            long ld = delta;
            if ((ld += (long)this.flowControlWindow) > Integer.MAX_VALUE) {
                ((Http2Channel)this.getChannel()).sendRstStream(this.streamId, 3);
                this.markBroken();
                return;
            }
            this.flowControlWindow += delta;
            this.flowControlLock.notifyAll();
        }
        if (exhausted) {
            ((Http2Channel)this.getChannel()).notifyFlowControlAllowed();
            if (this.isWriteResumed()) {
                this.resumeWritesInternal(true);
            }
        }
    }

    protected PooledByteBuffer[] allocateAll(PooledByteBuffer[] allHeaderBuffers, PooledByteBuffer currentBuffer) {
        PooledByteBuffer[] ret;
        if (allHeaderBuffers == null) {
            ret = new PooledByteBuffer[]{currentBuffer, ((Http2Channel)this.getChannel()).getBufferPool().allocate()};
            ByteBuffer newBuffer = ret[1].getBuffer();
            if (newBuffer.remaining() > ((Http2Channel)this.getChannel()).getSendMaxFrameSize()) {
                newBuffer.limit(newBuffer.position() + ((Http2Channel)this.getChannel()).getSendMaxFrameSize());
            }
        } else {
            ret = new PooledByteBuffer[allHeaderBuffers.length + 1];
            System.arraycopy(allHeaderBuffers, 0, ret, 0, allHeaderBuffers.length);
            ret[ret.length - 1] = ((Http2Channel)this.getChannel()).getBufferPool().allocate();
            ByteBuffer newBuffer = ret[ret.length - 1].getBuffer();
            if (newBuffer.remaining() > ((Http2Channel)this.getChannel()).getSendMaxFrameSize()) {
                newBuffer.limit(newBuffer.position() + ((Http2Channel)this.getChannel()).getSendMaxFrameSize());
            }
        }
        return ret;
    }

    void rstStream() {
        if (this.reset) {
            return;
        }
        this.reset = true;
        if (!this.isReadyForFlush()) {
            IoUtils.safeClose((Closeable)this);
        }
        ((Http2Channel)this.getChannel()).removeStreamSink(this.getStreamId());
    }
}

