/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.security.impl;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.AuthenticatedSessionManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.AuthenticationMechanism;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.SecurityContext;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.idm.Account;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.idm.IdentityManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class CachedAuthenticatedSessionMechanism
implements AuthenticationMechanism {
    private final IdentityManager identityManager;

    public CachedAuthenticatedSessionMechanism() {
        this(null);
    }

    public CachedAuthenticatedSessionMechanism(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        AuthenticatedSessionManager sessionManager = exchange.getAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY);
        if (sessionManager != null) {
            return this.runCached(exchange, securityContext, sessionManager);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome runCached(HttpServerExchange exchange, SecurityContext securityContext, AuthenticatedSessionManager sessionManager) {
        AuthenticatedSessionManager.AuthenticatedSession authSession = sessionManager.lookupSession(exchange);
        if (authSession != null) {
            Account account = this.getIdentityManager(securityContext).verify(authSession.getAccount());
            if (account != null) {
                securityContext.authenticationComplete(account, authSession.getMechanism(), false);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            sessionManager.clearSession(exchange);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return AuthenticationMechanism.ChallengeResult.NOT_SENT;
    }
}

