/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConduitWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ConduitFactory;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.WriteTimeoutException;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.WriteReadyHandler;

public final class BlockingWriteTimeoutHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ConduitWrapper<StreamSinkConduit> streamSinkConduitWrapper;

    private BlockingWriteTimeoutHandler(HttpHandler next, Duration writeTimeout) {
        this.next = next;
        this.streamSinkConduitWrapper = new TimeoutStreamSinkConduitWrapper(writeTimeout);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseWrapper(this.streamSinkConduitWrapper);
        this.next.handleRequest(exchange);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpHandler nextHandler;
        private Duration writeTimeout;

        private Builder() {
        }

        public Builder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = Objects.requireNonNull(writeTimeout, "A write timeout is required");
            return this;
        }

        public Builder nextHandler(HttpHandler nextHandler) {
            this.nextHandler = Objects.requireNonNull(nextHandler, "HttpHandler is required");
            return this;
        }

        public HttpHandler build() {
            HttpHandler next = Objects.requireNonNull(this.nextHandler, "HttpHandler is required");
            if (this.writeTimeout == null) {
                throw new IllegalArgumentException("A write timeout is required");
            }
            if (this.writeTimeout.isZero() || this.writeTimeout.isNegative()) {
                throw new IllegalArgumentException("Write timeout must be positive: " + this.writeTimeout);
            }
            return new BlockingWriteTimeoutHandler(next, this.writeTimeout);
        }
    }

    private static final class TimeoutStreamSinkConduit
    implements StreamSinkConduit {
        private final StreamSinkConduit delegate;
        private final ServerConnection serverConnection;
        private final long timeoutNanos;
        private long remaining;

        TimeoutStreamSinkConduit(StreamSinkConduit delegate, ServerConnection serverConnection, long timeoutNanos) {
            this.delegate = delegate;
            this.serverConnection = serverConnection;
            this.timeoutNanos = timeoutNanos;
            this.remaining = timeoutNanos;
        }

        @Override
        public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.transferFrom(fileChannel, position, count));
        }

        @Override
        public long transferFrom(StreamSourceChannel streamSourceChannel, long count, ByteBuffer byteBuffer) throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.transferFrom(streamSourceChannel, count, byteBuffer));
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.write(byteBuffer));
        }

        @Override
        public long write(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.write(byteBuffers, offset, length));
        }

        @Override
        public int writeFinal(ByteBuffer byteBuffer) throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.writeFinal(byteBuffer));
        }

        @Override
        public long writeFinal(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.writeFinal(byteBuffers, offset, length));
        }

        @Override
        public void terminateWrites() throws IOException {
            this.delegate.terminateWrites();
        }

        @Override
        public boolean isWriteShutdown() {
            return this.delegate.isWriteShutdown();
        }

        @Override
        public void resumeWrites() {
            this.delegate.resumeWrites();
        }

        @Override
        public void suspendWrites() {
            this.delegate.suspendWrites();
        }

        @Override
        public void wakeupWrites() {
            this.delegate.wakeupWrites();
        }

        @Override
        public boolean isWriteResumed() {
            return this.delegate.isWriteResumed();
        }

        @Override
        public void awaitWritable() throws IOException {
            this.awaitWritable(this.remaining, TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitWritable(long duration, TimeUnit unit) throws IOException {
            long startTime = System.nanoTime();
            long requestedNanos = unit.toNanos(duration);
            try {
                this.delegate.awaitWritable(Math.min(requestedNanos, this.remaining), TimeUnit.NANOSECONDS);
            }
            finally {
                this.remaining -= System.nanoTime() - startTime;
            }
            if (this.remaining < 0L) {
                WriteTimeoutException wte = UndertowMessages.MESSAGES.blockingWriteTimedOut(this.timeoutNanos);
                UndertowLogger.REQUEST_IO_LOGGER.blockingWriteTimedOut(wte);
                IoUtils.safeClose((Closeable)this.serverConnection);
                throw wte;
            }
        }

        @Override
        public XnioIoThread getWriteThread() {
            return this.delegate.getWriteThread();
        }

        @Override
        public void setWriteReadyHandler(WriteReadyHandler writeReadyHandler) {
            this.delegate.setWriteReadyHandler(writeReadyHandler);
        }

        @Override
        public void truncateWrites() throws IOException {
            this.delegate.truncateWrites();
        }

        @Override
        public boolean flush() throws IOException {
            return this.resetTimeoutIfWriteSucceeded(this.delegate.flush());
        }

        @Override
        public XnioWorker getWorker() {
            return this.delegate.getWorker();
        }

        private long resetTimeoutIfWriteSucceeded(long value) {
            if (value != 0L) {
                this.remaining = this.timeoutNanos;
            }
            return value;
        }

        private int resetTimeoutIfWriteSucceeded(int value) {
            if (value != 0) {
                this.remaining = this.timeoutNanos;
            }
            return value;
        }

        private boolean resetTimeoutIfWriteSucceeded(boolean value) {
            if (value) {
                this.remaining = this.timeoutNanos;
            }
            return value;
        }
    }

    private static final class TimeoutStreamSinkConduitWrapper
    implements ConduitWrapper<StreamSinkConduit> {
        private final long timeoutNanoseconds;

        TimeoutStreamSinkConduitWrapper(Duration writeTimeout) {
            this.timeoutNanoseconds = writeTimeout.toNanos();
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            return new TimeoutStreamSinkConduit(factory.create(), exchange.getConnection(), this.timeoutNanoseconds);
        }
    }
}

