/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.Handlers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ResponseCodeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.CanonicalPathUtils;

public class CanonicalPathHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CanonicalPathHandler() {
    }

    public CanonicalPathHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setRelativePath(CanonicalPathUtils.canonicalize(exchange.getRelativePath()));
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CanonicalPathHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public String toString() {
        return "canonical-path()";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new CanonicalPathHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "canonical-path";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

