/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.IoCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.Sender;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicates;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpContinue;

public class HttpContinueAcceptingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Predicate accept;

    public HttpContinueAcceptingHandler(HttpHandler next, Predicate accept) {
        this.next = next;
        this.accept = accept;
    }

    public HttpContinueAcceptingHandler(HttpHandler next) {
        this(next, Predicates.truePredicate());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (HttpContinue.requiresContinueResponse(exchange)) {
            if (this.accept.resolve(exchange)) {
                HttpContinue.sendContinueResponse(exchange, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        exchange.dispatch(HttpContinueAcceptingHandler.this.next);
                    }

                    @Override
                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                        exchange.endExchange();
                    }
                });
            } else {
                HttpContinue.rejectExchange(exchange);
            }
        } else {
            this.next.handleRequest(exchange);
        }
    }

    public String toString() {
        return "http-continue-accept()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "http-continue-accept";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return null;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper(Predicates.truePredicate());
        }
    }

    public static final class Wrapper
    implements HandlerWrapper {
        private final Predicate predicate;

        public Wrapper(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new HttpContinueAcceptingHandler(handler, this.predicate);
        }
    }
}

