/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributes;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ResponseCodeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;

public class SetHeaderHandler
implements HttpHandler {
    private final HttpString header;
    private final ExchangeAttribute value;
    private final HttpHandler next;

    public SetHeaderHandler(String header, String value) {
        if (value == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("value");
        }
        if (header == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("header");
        }
        this.next = ResponseCodeHandler.HANDLE_404;
        this.value = ExchangeAttributes.constant(value);
        this.header = new HttpString(header);
    }

    public SetHeaderHandler(HttpHandler next, String header, ExchangeAttribute value) {
        if (value == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("value");
        }
        if (header == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("header");
        }
        if (next == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("next");
        }
        this.next = next;
        this.value = value;
        this.header = new HttpString(header);
    }

    public SetHeaderHandler(HttpHandler next, String header, String value) {
        if (value == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("value");
        }
        if (header == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("header");
        }
        if (next == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("next");
        }
        this.next = next;
        this.value = ExchangeAttributes.constant(value);
        this.header = new HttpString(header);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(this.header, this.value.readAttribute(exchange));
        this.next.handleRequest(exchange);
    }

    public ExchangeAttribute getValue() {
        return this.value;
    }

    public HttpString getHeader() {
        return this.header;
    }

    public String toString() {
        return "set( header='" + this.header.toString() + "', value='" + this.value.toString() + "' )";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "header";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap parameters = new HashMap();
            parameters.put("header", String.class);
            parameters.put("value", ExchangeAttribute.class);
            return parameters;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> req = new HashSet<String>();
            req.add("value");
            req.add("header");
            return req;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            final ExchangeAttribute value = (ExchangeAttribute)config.get("value");
            final String header = (String)config.get("header");
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new SetHeaderHandler(handler, header, value);
                }
            };
        }
    }
}

