/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.WorkerUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioExecutor;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;

public class StuckThreadDetectionHandler
implements HttpHandler {
    public static final int DEFAULT_THRESHOLD = 600;
    private final AtomicInteger stuckCount = new AtomicInteger(0);
    private final int threshold;
    private final ConcurrentHashMap<Long, MonitoredThread> activeThreads = new ConcurrentHashMap();
    private final Queue<CompletedStuckThread> completedStuckThreadsQueue = new ConcurrentLinkedQueue<CompletedStuckThread>();
    private final HttpHandler next;
    private final Runnable stuckThreadTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long thresholdInMillis = (long)StuckThreadDetectionHandler.this.threshold * 1000L;
            for (MonitoredThread monitoredThread : StuckThreadDetectionHandler.this.activeThreads.values()) {
                long activeTime = monitoredThread.getActiveTimeInMillis();
                if (activeTime < thresholdInMillis || !monitoredThread.markAsStuckIfStillRunning()) continue;
                int numStuckThreads = StuckThreadDetectionHandler.this.stuckCount.incrementAndGet();
                StuckThreadDetectionHandler.this.notifyStuckThreadDetected(monitoredThread, activeTime, numStuckThreads);
            }
            CompletedStuckThread completedStuckThread = (CompletedStuckThread)StuckThreadDetectionHandler.this.completedStuckThreadsQueue.poll();
            while (completedStuckThread != null) {
                int numStuckThreads = StuckThreadDetectionHandler.this.stuckCount.decrementAndGet();
                StuckThreadDetectionHandler.this.notifyStuckThreadCompleted(completedStuckThread, numStuckThreads);
                completedStuckThread = (CompletedStuckThread)StuckThreadDetectionHandler.this.completedStuckThreadsQueue.poll();
            }
            StuckThreadDetectionHandler stuckThreadDetectionHandler = StuckThreadDetectionHandler.this;
            synchronized (stuckThreadDetectionHandler) {
                if (StuckThreadDetectionHandler.this.activeThreads.isEmpty()) {
                    StuckThreadDetectionHandler.this.timerKey = null;
                } else {
                    StuckThreadDetectionHandler.this.timerKey = WorkerUtils.executeAfter((XnioIoThread)Thread.currentThread(), StuckThreadDetectionHandler.this.stuckThreadTask, 1L, TimeUnit.SECONDS);
                }
            }
        }
    };
    private volatile XnioExecutor.Key timerKey;

    public StuckThreadDetectionHandler(HttpHandler next) {
        this(600, next);
    }

    public StuckThreadDetectionHandler(int threshold, HttpHandler next) {
        this.threshold = threshold;
        this.next = next;
    }

    public int getThreshold() {
        return this.threshold;
    }

    private void notifyStuckThreadDetected(MonitoredThread monitoredThread, long activeTime, int numStuckThreads) {
        Throwable th = new Throwable();
        th.setStackTrace(monitoredThread.getThread().getStackTrace());
        UndertowLogger.REQUEST_LOGGER.stuckThreadDetected(monitoredThread.getThread().getName(), monitoredThread.getThread().getId(), activeTime, monitoredThread.getStartTime(), monitoredThread.getRequestUri(), this.threshold, numStuckThreads, th);
    }

    private void notifyStuckThreadCompleted(CompletedStuckThread thread, int numStuckThreads) {
        UndertowLogger.REQUEST_LOGGER.stuckThreadCompleted(thread.getName(), thread.getId(), thread.getTotalActiveTime(), numStuckThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Long key = Thread.currentThread().getId();
        MonitoredThread monitoredThread = new MonitoredThread(Thread.currentThread(), exchange.getRequestURI() + exchange.getQueryString());
        this.activeThreads.put(key, monitoredThread);
        if (this.timerKey == null) {
            StuckThreadDetectionHandler stuckThreadDetectionHandler = this;
            synchronized (stuckThreadDetectionHandler) {
                if (this.timerKey == null) {
                    this.timerKey = exchange.getIoThread().executeAfter(this.stuckThreadTask, 1L, TimeUnit.SECONDS);
                }
            }
        }
        try {
            this.next.handleRequest(exchange);
        }
        finally {
            this.activeThreads.remove(key);
            if (monitoredThread.markAsDone() == MonitoredThreadState.STUCK) {
                this.completedStuckThreadsQueue.add(new CompletedStuckThread(monitoredThread.getThread(), monitoredThread.getActiveTimeInMillis()));
            }
        }
    }

    public long[] getStuckThreadIds() {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            if (!monitoredThread.isMarkedAsStuck()) continue;
            idList.add(monitoredThread.getThread().getId());
        }
        long[] result = new long[idList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Long)idList.get(i);
        }
        return result;
    }

    public String toString() {
        return "stuck-thread-detector( " + this.threshold + " )";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "stuck-thread-detector";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("threshhold", Integer.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return "threshhold";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            Integer threshhold = (Integer)config.get("threshhold");
            if (threshhold == null) {
                return new Wrapper();
            }
            return new Wrapper(threshhold);
        }
    }

    public static final class Wrapper
    implements HandlerWrapper {
        private final int threshhold;

        public Wrapper(int threshhold) {
            this.threshhold = threshhold;
        }

        public Wrapper() {
            this.threshhold = 600;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new StuckThreadDetectionHandler(this.threshhold, handler);
        }
    }

    private static enum MonitoredThreadState {
        RUNNING,
        STUCK,
        DONE;

    }

    private static class CompletedStuckThread {
        private final String threadName;
        private final long threadId;
        private final long totalActiveTime;

        CompletedStuckThread(Thread thread, long totalActiveTime) {
            this.threadName = thread.getName();
            this.threadId = thread.getId();
            this.totalActiveTime = totalActiveTime;
        }

        public String getName() {
            return this.threadName;
        }

        public long getId() {
            return this.threadId;
        }

        public long getTotalActiveTime() {
            return this.totalActiveTime;
        }
    }

    private static class MonitoredThread {
        private final Thread thread;
        private final String requestUri;
        private final long start;
        private final AtomicInteger state = new AtomicInteger(MonitoredThreadState.RUNNING.ordinal());

        MonitoredThread(Thread thread, String requestUri) {
            this.thread = thread;
            this.requestUri = requestUri;
            this.start = System.currentTimeMillis();
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public long getActiveTimeInMillis() {
            return System.currentTimeMillis() - this.start;
        }

        public Date getStartTime() {
            return new Date(this.start);
        }

        public boolean markAsStuckIfStillRunning() {
            return this.state.compareAndSet(MonitoredThreadState.RUNNING.ordinal(), MonitoredThreadState.STUCK.ordinal());
        }

        public MonitoredThreadState markAsDone() {
            int val = this.state.getAndSet(MonitoredThreadState.DONE.ordinal());
            return MonitoredThreadState.values()[val];
        }

        boolean isMarkedAsStuck() {
            return this.state.get() == MonitoredThreadState.STUCK.ordinal();
        }
    }
}

