/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributes;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicates;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicatesHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.PredicatedHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.FileUtils;

public class PredicatedHandlersParser {
    public static final String ELSE = "else";
    public static final String ARROW = "->";
    public static final String NOT = "not";
    public static final String OR = "or";
    public static final String AND = "and";
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static List<PredicatedHandler> parse(File file, ClassLoader classLoader) {
        return PredicatedHandlersParser.parse(file.toPath(), classLoader);
    }

    public static List<PredicatedHandler> parse(Path file, ClassLoader classLoader) {
        try {
            return PredicatedHandlersParser.parse(new String(Files.readAllBytes(file), StandardCharsets.UTF_8), classLoader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<PredicatedHandler> parse(InputStream inputStream, ClassLoader classLoader) {
        return PredicatedHandlersParser.parse(FileUtils.readFile(inputStream), classLoader);
    }

    public static List<PredicatedHandler> parse(String contents, ClassLoader classLoader) {
        Deque<Token> tokens = PredicatedHandlersParser.tokenize(contents);
        Node node = PredicatedHandlersParser.parse(contents, tokens);
        Map<String, PredicateBuilder> predicateBuilders = PredicatedHandlersParser.loadPredicateBuilders(classLoader);
        Map<String, HandlerBuilder> handlerBuilders = PredicatedHandlersParser.loadHandlerBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicatedHandlersParser.handleNode(contents, node, predicateBuilders, handlerBuilders, attributeParser);
    }

    public static Predicate parsePredicate(String string, ClassLoader classLoader) {
        Deque<Token> tokens = PredicatedHandlersParser.tokenize(string);
        Node node = PredicatedHandlersParser.parse(string, tokens);
        Map<String, PredicateBuilder> predicateBuilders = PredicatedHandlersParser.loadPredicateBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicatedHandlersParser.handlePredicateNode(string, node, predicateBuilders, attributeParser);
    }

    public static HandlerWrapper parseHandler(String string, ClassLoader classLoader) {
        Deque<Token> tokens = PredicatedHandlersParser.tokenize(string);
        Node node = PredicatedHandlersParser.parse(string, tokens);
        Map<String, HandlerBuilder> handlerBuilders = PredicatedHandlersParser.loadHandlerBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicatedHandlersParser.handleHandlerNode(string, (ExpressionNode)node, handlerBuilders, attributeParser);
    }

    private static List<PredicatedHandler> handleNode(String contents, Node node, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser attributeParser) {
        if (node instanceof BlockNode) {
            return PredicatedHandlersParser.handleBlockNode(contents, (BlockNode)node, predicateBuilders, handlerBuilders, attributeParser);
        }
        if (node instanceof ExpressionNode) {
            HandlerWrapper handler = PredicatedHandlersParser.handleHandlerNode(contents, (ExpressionNode)node, handlerBuilders, attributeParser);
            return Collections.singletonList(new PredicatedHandler(Predicates.truePredicate(), handler));
        }
        if (node instanceof PredicateOperatorNode) {
            return Collections.singletonList(PredicatedHandlersParser.handlePredicateOperatorNode(contents, (PredicateOperatorNode)node, predicateBuilders, handlerBuilders, attributeParser));
        }
        throw PredicatedHandlersParser.error(contents, node.getToken().getPosition(), "unexpected token " + node.getToken());
    }

    private static PredicatedHandler handlePredicateOperatorNode(String contents, PredicateOperatorNode node, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        Predicate predicate = PredicatedHandlersParser.handlePredicateNode(contents, node.getLeft(), predicateBuilders, parser);
        HandlerWrapper ret = PredicatedHandlersParser.handlePredicatedAction(contents, node.getRight(), predicateBuilders, handlerBuilders, parser);
        HandlerWrapper elseBranch = null;
        if (node.getElseBranch() != null) {
            elseBranch = PredicatedHandlersParser.handlePredicatedAction(contents, node.getElseBranch(), predicateBuilders, handlerBuilders, parser);
        }
        return new PredicatedHandler(predicate, ret, elseBranch);
    }

    private static HandlerWrapper handlePredicatedAction(String contents, Node node, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        if (node instanceof ExpressionNode) {
            return PredicatedHandlersParser.handleHandlerNode(contents, (ExpressionNode)node, handlerBuilders, parser);
        }
        if (node instanceof BlockNode) {
            List<PredicatedHandler> handlers = PredicatedHandlersParser.handleBlockNode(contents, (BlockNode)node, predicateBuilders, handlerBuilders, parser);
            return new PredicatesHandler.Wrapper(handlers, false);
        }
        if (node instanceof PredicateOperatorNode) {
            List<PredicatedHandler> handlers = Collections.singletonList(PredicatedHandlersParser.handlePredicateOperatorNode(contents, (PredicateOperatorNode)node, predicateBuilders, handlerBuilders, parser));
            return new PredicatesHandler.Wrapper(handlers, false);
        }
        throw PredicatedHandlersParser.error(contents, node.getToken().getPosition(), "unexpected token " + node.getToken());
    }

    private static List<PredicatedHandler> handleBlockNode(String contents, BlockNode node, Map<String, PredicateBuilder> predicateBuilders, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        ArrayList<PredicatedHandler> ret = new ArrayList<PredicatedHandler>();
        for (Node line : node.getBlock()) {
            ret.addAll(PredicatedHandlersParser.handleNode(contents, line, predicateBuilders, handlerBuilders, parser));
        }
        return ret;
    }

    private static HandlerWrapper handleHandlerNode(String contents, ExpressionNode node, Map<String, HandlerBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        Token token = node.getToken();
        HandlerBuilder builder = handlerBuilders.get(token.getToken());
        if (builder == null) {
            throw PredicatedHandlersParser.error(contents, token.getPosition(), "no handler named " + token.getToken() + " known handlers are " + handlerBuilders.keySet());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashSet requiredParameters = builder.requiredParameters();
        requiredParameters = requiredParameters == null ? Collections.emptySet() : new HashSet(requiredParameters);
        for (Map.Entry<String, Node> val : node.getValues().entrySet()) {
            Class<?> type;
            String name = val.getKey();
            if (name == null) {
                if (builder.defaultParameter() == null) {
                    throw PredicatedHandlersParser.error(contents, token.getPosition(), "default parameter not supported");
                }
                name = builder.defaultParameter();
            }
            if ((type = builder.parameters().get(name)) == null) {
                throw PredicatedHandlersParser.error(contents, val.getValue().getToken().getPosition(), "unknown parameter " + name);
            }
            if (val.getValue() instanceof ValueNode) {
                parameters.put(name, PredicatedHandlersParser.coerceToType(contents, val.getValue().getToken(), type, parser));
            } else if (val.getValue() instanceof ArrayNode) {
                parameters.put(name, PredicatedHandlersParser.readArrayType(contents, name, (ArrayNode)val.getValue(), parser, type));
            } else {
                throw PredicatedHandlersParser.error(contents, val.getValue().getToken().getPosition(), "unexpected node " + val.getValue());
            }
            requiredParameters.remove(name);
        }
        if (!requiredParameters.isEmpty()) {
            throw PredicatedHandlersParser.error(contents, token.getPosition(), "required parameters " + requiredParameters + " not provided for handler " + builder.name());
        }
        return builder.build(parameters);
    }

    private static Predicate handlePredicateNode(String contents, Node node, Map<String, PredicateBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        if (node instanceof AndNode) {
            AndNode andNode = (AndNode)node;
            return Predicates.and(PredicatedHandlersParser.handlePredicateNode(contents, andNode.getLeft(), handlerBuilders, parser), PredicatedHandlersParser.handlePredicateNode(contents, andNode.getRight(), handlerBuilders, parser));
        }
        if (node instanceof OrNode) {
            OrNode orNode = (OrNode)node;
            return Predicates.or(PredicatedHandlersParser.handlePredicateNode(contents, orNode.getLeft(), handlerBuilders, parser), PredicatedHandlersParser.handlePredicateNode(contents, orNode.getRight(), handlerBuilders, parser));
        }
        if (node instanceof NotNode) {
            NotNode orNode = (NotNode)node;
            return Predicates.not(PredicatedHandlersParser.handlePredicateNode(contents, orNode.getNode(), handlerBuilders, parser));
        }
        if (node instanceof ExpressionNode) {
            return PredicatedHandlersParser.handlePredicateExpressionNode(contents, (ExpressionNode)node, handlerBuilders, parser);
        }
        if (node instanceof OperatorNode) {
            switch (node.getToken().getToken()) {
                case "true": {
                    return Predicates.truePredicate();
                }
                case "false": {
                    return Predicates.falsePredicate();
                }
            }
        }
        throw PredicatedHandlersParser.error(contents, node.getToken().getPosition(), "unexpected node " + node);
    }

    private static Predicate handlePredicateExpressionNode(String contents, ExpressionNode node, Map<String, PredicateBuilder> handlerBuilders, ExchangeAttributeParser parser) {
        Token token = node.getToken();
        PredicateBuilder builder = handlerBuilders.get(token.getToken());
        if (builder == null) {
            throw PredicatedHandlersParser.error(contents, token.getPosition(), "no predicate named " + token.getToken() + " known predicates are " + handlerBuilders.keySet());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashSet requiredParameters = builder.requiredParameters();
        requiredParameters = requiredParameters == null ? Collections.emptySet() : new HashSet(requiredParameters);
        for (Map.Entry<String, Node> val : node.getValues().entrySet()) {
            Class<?> type;
            String name = val.getKey();
            if (name == null) {
                if (builder.defaultParameter() == null) {
                    throw PredicatedHandlersParser.error(contents, token.getPosition(), "default parameter not supported");
                }
                name = builder.defaultParameter();
            }
            if ((type = builder.parameters().get(name)) == null) {
                throw PredicatedHandlersParser.error(contents, val.getValue().getToken().getPosition(), "unknown parameter " + name);
            }
            if (val.getValue() instanceof ValueNode) {
                parameters.put(name, PredicatedHandlersParser.coerceToType(contents, val.getValue().getToken(), type, parser));
            } else if (val.getValue() instanceof ArrayNode) {
                parameters.put(name, PredicatedHandlersParser.readArrayType(contents, name, (ArrayNode)val.getValue(), parser, type));
            } else {
                throw PredicatedHandlersParser.error(contents, val.getValue().getToken().getPosition(), "unexpected node " + val.getValue());
            }
            requiredParameters.remove(name);
        }
        if (!requiredParameters.isEmpty()) {
            throw PredicatedHandlersParser.error(contents, token.getPosition(), "required parameters " + requiredParameters + " not provided for predicate " + builder.name());
        }
        return builder.build(parameters);
    }

    private static Object readArrayType(String string, String paramName, ArrayNode value, ExchangeAttributeParser parser, Class type) {
        if (!type.isArray()) {
            throw PredicatedHandlersParser.error(string, value.getToken().getPosition(), "parameter is not an array type " + paramName);
        }
        Class<?> componentType = type.getComponentType();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Token token : value.getValues()) {
            values.add(PredicatedHandlersParser.coerceToType(string, token, componentType, parser));
        }
        Object array = Array.newInstance(componentType, values.size());
        for (int i = 0; i < values.size(); ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    private static Object coerceToType(String string, Token token, Class<?> type, ExchangeAttributeParser attributeParser) {
        if (type.isArray()) {
            Object array = Array.newInstance(type.getComponentType(), 1);
            Array.set(array, 0, PredicatedHandlersParser.coerceToType(string, token, type.getComponentType(), attributeParser));
            return array;
        }
        if (type == String.class) {
            return token.getToken();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(token.getToken());
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Byte.valueOf(token.getToken());
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            if (token.getToken().length() != 1) {
                throw PredicatedHandlersParser.error(string, token.getPosition(), "Cannot coerce " + token.getToken() + " to a Character");
            }
            return Character.valueOf(token.getToken().charAt(0));
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.valueOf(token.getToken());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.valueOf(token.getToken());
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.valueOf(token.getToken());
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(token.getToken());
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.valueOf(token.getToken());
        }
        if (type.equals(ExchangeAttribute.class)) {
            return attributeParser.parse(token.getToken());
        }
        return token.getToken();
    }

    private static Map<String, PredicateBuilder> loadPredicateBuilders(ClassLoader classLoader) {
        ServiceLoader<PredicateBuilder> loader = ServiceLoader.load(PredicateBuilder.class, classLoader);
        HashMap<String, PredicateBuilder> ret = new HashMap<String, PredicateBuilder>();
        for (PredicateBuilder builder : loader) {
            if (ret.containsKey(builder.name())) {
                if (((PredicateBuilder)ret.get(builder.name())).getClass() == builder.getClass()) continue;
                throw UndertowMessages.MESSAGES.moreThanOnePredicateWithName(builder.name(), builder.getClass(), ((PredicateBuilder)ret.get(builder.name())).getClass());
            }
            ret.put(builder.name(), builder);
        }
        return ret;
    }

    private static Map<String, HandlerBuilder> loadHandlerBuilders(ClassLoader classLoader) {
        ServiceLoader<HandlerBuilder> loader = ServiceLoader.load(HandlerBuilder.class, classLoader);
        HashMap<String, HandlerBuilder> ret = new HashMap<String, HandlerBuilder>();
        for (HandlerBuilder builder : loader) {
            if (ret.containsKey(builder.name())) {
                if (((HandlerBuilder)ret.get(builder.name())).getClass() == builder.getClass()) continue;
                throw UndertowMessages.MESSAGES.moreThanOneHandlerWithName(builder.name(), builder.getClass(), ((HandlerBuilder)ret.get(builder.name())).getClass());
            }
            ret.put(builder.name(), builder);
        }
        return ret;
    }

    static Node parse(String string, Deque<Token> tokens) {
        return PredicatedHandlersParser.parse(string, tokens, true);
    }

    static Node parse(String string, Deque<Token> tokens, boolean topLevel) {
        ArrayDeque<Token> operatorStack = new ArrayDeque<Token>();
        ArrayDeque<Node> output = new ArrayDeque<Node>();
        ArrayList<Node> blocks = new ArrayList<Node>();
        block0: while (!tokens.isEmpty()) {
            Token token = tokens.poll();
            if (token.getToken().equals("{")) {
                output.push(PredicatedHandlersParser.parse(string, tokens, false));
                continue;
            }
            if (token.getToken().equals("}")) {
                if (!topLevel) break;
                throw PredicatedHandlersParser.error(string, token.getPosition(), "Unexpected token");
            }
            if (token.getToken().equals("\n") || token.getToken().equals(";")) {
                if (token.getToken().equals(";") && tokens.peek() != null && tokens.peek().getToken().equals(ELSE)) continue;
                PredicatedHandlersParser.handleLineEnd(string, operatorStack, output, blocks);
                continue;
            }
            if (PredicatedHandlersParser.isSpecialChar(token.getToken())) {
                if (token.getToken().equals("(")) {
                    operatorStack.push(token);
                    continue;
                }
                if (token.getToken().equals(")")) {
                    while (true) {
                        Token op;
                        if ((op = (Token)operatorStack.pop()) == null) {
                            throw PredicatedHandlersParser.error(string, token.getPosition(), "Unexpected end of input");
                        }
                        if (op.getToken().equals("(")) continue block0;
                        output.push(new OperatorNode(op));
                    }
                }
                output.push(new OperatorNode(token));
                continue;
            }
            if (PredicatedHandlersParser.isOperator(token.getToken()) && !token.getToken().equals(ELSE)) {
                int exitingPrec;
                int prec = PredicatedHandlersParser.precedence(token.getToken());
                Token top = (Token)operatorStack.peek();
                while (top != null && !top.getToken().equals("(") && prec <= (exitingPrec = PredicatedHandlersParser.precedence(top.getToken()))) {
                    output.push(new OperatorNode((Token)operatorStack.pop()));
                    top = (Token)operatorStack.peek();
                }
                operatorStack.push(token);
                continue;
            }
            output.push(PredicatedHandlersParser.parseExpression(string, token, tokens));
        }
        PredicatedHandlersParser.handleLineEnd(string, operatorStack, output, blocks);
        if (blocks.size() == 1) {
            return (Node)blocks.get(0);
        }
        return new BlockNode(new Token("", 0), blocks);
    }

    private static void handleLineEnd(String string, Deque<Token> operatorStack, Deque<Node> output, List<Node> blocks) {
        while (!operatorStack.isEmpty()) {
            Token op = operatorStack.pop();
            if (op.getToken().equals(")")) {
                throw PredicatedHandlersParser.error(string, string.length(), "Mismatched parenthesis");
            }
            output.push(new OperatorNode(op));
        }
        if (output.isEmpty()) {
            return;
        }
        Node predicate = PredicatedHandlersParser.collapseOutput(output.pop(), output);
        if (!output.isEmpty()) {
            throw PredicatedHandlersParser.error(string, output.getFirst().getToken().getPosition(), "Invalid expression");
        }
        blocks.add(predicate);
    }

    private static Node collapseOutput(Node token, Deque<Node> tokens) {
        if (token instanceof OperatorNode) {
            OperatorNode node = (OperatorNode)token;
            if (node.token.getToken().equals(AND)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                Node n2 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                return new AndNode(token.getToken(), n2, n1);
            }
            if (node.token.getToken().equals(OR)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                Node n2 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                return new OrNode(token.getToken(), n2, n1);
            }
            if (node.token.getToken().equals(NOT)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                return new NotNode(token.getToken(), n1);
            }
            if (node.token.getToken().equals(ARROW)) {
                Node n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                Node n2 = null;
                Node elseBranch = null;
                Node popped = tokens.pop();
                if (popped.getToken().getToken().equals(ELSE)) {
                    elseBranch = n1;
                    n1 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                    n2 = PredicatedHandlersParser.collapseOutput(tokens.pop(), tokens);
                } else {
                    n2 = PredicatedHandlersParser.collapseOutput(popped, tokens);
                }
                return new PredicateOperatorNode(token.getToken(), n2, n1, elseBranch);
            }
            return token;
        }
        return token;
    }

    private static Node parseExpression(String string, Token token, Deque<Token> tokens) {
        if (token.getToken().equals(TRUE)) {
            return new OperatorNode(token);
        }
        if (token.getToken().equals(FALSE)) {
            return new OperatorNode(token);
        }
        Token next = tokens.peek();
        String endChar = ")";
        if (next != null && (next.getToken().equals("[") || next.getToken().equals("("))) {
            if (next.getToken().equals("[")) {
                endChar = "]";
                UndertowLogger.ROOT_LOGGER.oldStylePredicateSyntax(string);
            }
            HashMap<String, Node> values = new HashMap<String, Node>();
            tokens.poll();
            next = tokens.poll();
            if (next == null) {
                throw PredicatedHandlersParser.error(string, string.length(), "Unexpected end of input");
            }
            if (next.getToken().equals("{")) {
                return PredicatedHandlersParser.handleSingleArrayValue(string, token, tokens, endChar);
            }
            while (!next.getToken().equals(endChar)) {
                Token equals = tokens.poll();
                if (equals == null) {
                    throw PredicatedHandlersParser.error(string, string.length(), "Unexpected end of input");
                }
                if (!equals.getToken().equals("=")) {
                    if (equals.getToken().equals(endChar) && values.isEmpty()) {
                        return PredicatedHandlersParser.handleSingleValue(token, next);
                    }
                    if (equals.getToken().equals(",")) {
                        tokens.push(equals);
                        tokens.push(next);
                        return PredicatedHandlersParser.handleSingleVarArgsValue(string, token, tokens, endChar);
                    }
                    throw PredicatedHandlersParser.error(string, equals.getPosition(), "Unexpected token");
                }
                Token value = tokens.poll();
                if (value == null) {
                    throw PredicatedHandlersParser.error(string, string.length(), "Unexpected end of input");
                }
                if (value.getToken().equals("{")) {
                    values.put(next.getToken(), new ArrayNode(value, PredicatedHandlersParser.readArrayType(string, tokens, "}")));
                } else {
                    if (PredicatedHandlersParser.isOperator(value.getToken()) || PredicatedHandlersParser.isSpecialChar(value.getToken())) {
                        throw PredicatedHandlersParser.error(string, value.getPosition(), "Unexpected token");
                    }
                    values.put(next.getToken(), new ValueNode(value));
                }
                next = tokens.poll();
                if (next == null) {
                    throw PredicatedHandlersParser.error(string, string.length(), "Unexpected end of input");
                }
                if (next.getToken().equals(endChar)) continue;
                if (!next.getToken().equals(",")) {
                    throw PredicatedHandlersParser.error(string, string.length(), "Expecting , or " + endChar);
                }
                next = tokens.poll();
                if (next != null) continue;
                throw PredicatedHandlersParser.error(string, string.length(), "Unexpected end of input");
            }
            return new ExpressionNode(token, values);
        }
        if (next != null && PredicatedHandlersParser.isSpecialChar(next.getToken())) {
            throw PredicatedHandlersParser.error(string, next.getPosition(), "Unexpected character");
        }
        return new ExpressionNode(token, Collections.emptyMap());
    }

    private static Node handleSingleArrayValue(String string, Token builder, Deque<Token> tokens, String endChar) {
        List<Token> array = PredicatedHandlersParser.readArrayType(string, tokens, "}");
        Token close = tokens.poll();
        if (!close.getToken().equals(endChar)) {
            throw PredicatedHandlersParser.error(string, close.getPosition(), "expected " + endChar);
        }
        return new ExpressionNode(builder, Collections.singletonMap(null, new ArrayNode(builder, array)));
    }

    private static Node handleSingleVarArgsValue(String string, Token expressionName, Deque<Token> tokens, String endChar) {
        List<Token> array = PredicatedHandlersParser.readArrayType(string, tokens, endChar);
        return new ExpressionNode(expressionName, Collections.singletonMap(null, new ArrayNode(expressionName, array)));
    }

    private static List<Token> readArrayType(String string, Deque<Token> tokens, String expectedEndToken) {
        ArrayList<Token> values = new ArrayList<Token>();
        Token token = tokens.poll();
        if (token.getToken().equals(expectedEndToken)) {
            return Collections.emptyList();
        }
        while (token != null) {
            Token commaOrEnd = tokens.poll();
            values.add(token);
            if (commaOrEnd.getToken().equals(expectedEndToken)) {
                return values;
            }
            if (!commaOrEnd.getToken().equals(",")) {
                throw PredicatedHandlersParser.error(string, commaOrEnd.getPosition(), "expected either , or " + expectedEndToken);
            }
            token = tokens.poll();
        }
        throw PredicatedHandlersParser.error(string, string.length(), "unexpected end of input in array");
    }

    private static Node handleSingleValue(Token token, Token next) {
        return new ExpressionNode(token, Collections.singletonMap(null, new ValueNode(next)));
    }

    private static int precedence(String operator) {
        if (operator.equals(NOT)) {
            return 3;
        }
        if (operator.equals(AND)) {
            return 2;
        }
        if (operator.equals(OR)) {
            return 1;
        }
        if (operator.equals(ARROW)) {
            return -1000;
        }
        throw new IllegalStateException();
    }

    private static boolean isOperator(String op) {
        return op.equals(AND) || op.equals(OR) || op.equals(NOT) || op.equals(ARROW);
    }

    private static boolean isSpecialChar(String token) {
        if (token.length() == 1) {
            char c = token.charAt(0);
            switch (c) {
                case '(': 
                case ')': 
                case ',': 
                case '=': 
                case '[': 
                case ']': {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static Deque<Token> tokenize(String string) {
        char currentStringDelim = '\u0000';
        boolean inVariable = false;
        StringBuilder current = new StringBuilder();
        ArrayDeque<Token> ret = new ArrayDeque<Token>();
        block8: for (int pos = 0; pos < string.length(); ++pos) {
            char c = string.charAt(pos);
            if (currentStringDelim != '\u0000') {
                if (c == currentStringDelim) {
                    if (current.length() > 0) {
                        if (current.charAt(current.length() - 1) != '\\') {
                            ret.add(new Token(current.toString(), pos));
                            current.setLength(0);
                            currentStringDelim = '\u0000';
                            continue;
                        }
                        current.deleteCharAt(current.length() - 1);
                        current.append(c);
                        continue;
                    }
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    currentStringDelim = '\u0000';
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    currentStringDelim = '\u0000';
                    ret.add(new Token("\n", pos));
                    continue;
                }
                current.append(c);
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (current.length() == 0) continue block8;
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (current.length() != 0) {
                        ret.add(new Token(current.toString(), pos));
                        current.setLength(0);
                    }
                    ret.add(new Token("\n", pos));
                    continue block8;
                }
                case '(': 
                case ')': 
                case ',': 
                case ';': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (inVariable) {
                        current.append(c);
                        if (c != '}') continue block8;
                        inVariable = false;
                        continue block8;
                    }
                    if (current.length() != 0) {
                        ret.add(new Token(current.toString(), pos));
                        current.setLength(0);
                    }
                    ret.add(new Token("" + c, pos));
                    continue block8;
                }
                case '\"': 
                case '\'': {
                    if (current.length() != 0) {
                        throw PredicatedHandlersParser.error(string, pos, "Unexpected token");
                    }
                    currentStringDelim = c;
                    continue block8;
                }
                case '$': 
                case '%': {
                    current.append(c);
                    if (string.charAt(pos + 1) != '{') continue block8;
                    inVariable = true;
                    continue block8;
                }
                case '-': {
                    if (inVariable) {
                        current.append(c);
                        continue block8;
                    }
                    if (pos != string.length() && string.charAt(pos + 1) == '>') {
                        ++pos;
                        if (current.length() != 0) {
                            ret.add(new Token(current.toString(), pos));
                            current.setLength(0);
                        }
                        ret.add(new Token(ARROW, pos));
                        continue block8;
                    }
                    current.append(c);
                    continue block8;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            ret.add(new Token(current.toString(), string.length()));
        }
        return ret;
    }

    private static IllegalStateException error(String string, int pos, String reason) {
        int i;
        StringBuilder b = new StringBuilder();
        int linePos = 0;
        for (i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                if (i >= pos) break;
                linePos = 0;
            } else if (i < pos) {
                ++linePos;
            }
            b.append(string.charAt(i));
        }
        b.append('\n');
        for (i = 0; i < linePos; ++i) {
            b.append(' ');
        }
        b.append('^');
        throw UndertowMessages.MESSAGES.errorParsingPredicateString(reason, b.toString());
    }

    static final class Token {
        private final String token;
        private final int position;

        Token(String token, int position) {
            this.token = token;
            this.position = position;
        }

        public String getToken() {
            return this.token;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return this.token + " <" + this.position + ">";
        }
    }

    static class BlockNode
    implements Node {
        private final Token token;
        private final List<Node> block;

        BlockNode(Token token, List<Node> block) {
            this.token = token;
            this.block = block;
        }

        public List<Node> getBlock() {
            return this.block;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class NotNode
    implements Node {
        private final Token token;
        private final Node node;

        NotNode(Token token, Node node) {
            this.token = token;
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class PredicateOperatorNode
    implements Node {
        private final Token token;
        private final Node left;
        private final Node right;
        private final Node elseBranch;

        PredicateOperatorNode(Token token, Node left, Node right, Node elseBranch) {
            this.token = token;
            this.left = left;
            this.right = right;
            this.elseBranch = elseBranch;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        public Node getElseBranch() {
            return this.elseBranch;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class OrNode
    implements Node {
        private final Token token;
        private final Node left;
        private final Node right;

        OrNode(Token token, Node left, Node right) {
            this.token = token;
            this.left = left;
            this.right = right;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class AndNode
    implements Node {
        private final Token token;
        private final Node left;
        private final Node right;

        AndNode(Token token, Node left, Node right) {
            this.token = token;
            this.left = left;
            this.right = right;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class OperatorNode
    implements Node {
        private final Token token;

        private OperatorNode(Token token) {
            this.token = token;
        }

        @Override
        public Token getToken() {
            return this.token;
        }
    }

    static class ValueNode
    implements Node {
        private final Token value;

        private ValueNode(Token value) {
            this.value = value;
        }

        public Token getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.getToken();
        }

        @Override
        public Token getToken() {
            return this.value;
        }
    }

    static class ArrayNode
    implements Node {
        private final Token start;
        private final List<Token> values;

        private ArrayNode(Token start, List<Token> tokens) {
            this.start = start;
            this.values = tokens;
        }

        public List<Token> getValues() {
            return this.values;
        }

        @Override
        public Token getToken() {
            return this.start;
        }
    }

    static class ExpressionNode
    implements Node {
        private final Token token;
        private final Map<String, Node> values;

        private ExpressionNode(Token token, Map<String, Node> values) {
            this.token = token;
            this.values = values;
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        public Map<String, Node> getValues() {
            return this.values;
        }
    }

    public static interface Node {
        public Token getToken();
    }
}

