/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ConstantExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributes;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.SetAttributeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;

public class RewriteHandlerBuilder
implements HandlerBuilder {
    @Override
    public String name() {
        return "rewrite";
    }

    @Override
    public Map<String, Class<?>> parameters() {
        return Collections.singletonMap("value", ExchangeAttribute.class);
    }

    @Override
    public Set<String> requiredParameters() {
        return Collections.singleton("value");
    }

    @Override
    public String defaultParameter() {
        return "value";
    }

    @Override
    public HandlerWrapper build(Map<String, Object> config) {
        final ExchangeAttribute configValue = (ExchangeAttribute)config.get("value");
        ExchangeAttribute tmpValue = null;
        tmpValue = configValue instanceof ConstantExchangeAttribute ? new ConstantExchangeAttribute(this.normalize(configValue.readAttribute(null))) : new ExchangeAttribute(){

            @Override
            public String readAttribute(HttpServerExchange exchange) {
                return RewriteHandlerBuilder.this.normalize(configValue.readAttribute(exchange));
            }

            @Override
            public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
                throw new ReadOnlyAttributeException("constant", newValue);
            }

            public String toString() {
                return "NDA";
            }
        };
        final ExchangeAttribute value = tmpValue;
        return new HandlerWrapper(){

            @Override
            public HttpHandler wrap(HttpHandler handler) {
                return new SetAttributeHandler(handler, ExchangeAttributes.relativePath(), value){

                    @Override
                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        UndertowLogger.PREDICATE_LOGGER.debugf("Request rewritten to [%s] for %s.", (Object)this.getValue().readAttribute(exchange), (Object)exchange);
                        super.handleRequest(exchange);
                    }

                    @Override
                    public String toString() {
                        return "rewrite( '" + this.getValue().toString() + "' )";
                    }
                };
            }
        };
    }

    private String normalize(String readAttribute) {
        if (readAttribute.startsWith("/")) {
            return readAttribute;
        }
        return "/" + readAttribute;
    }
}

