/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.Handlers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConduitWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ResponseCodeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.CachedHttpRequest;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.DirectBufferCache;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.ResponseCache;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.ResponseCachingStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.AllowedContentEncodings;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ConduitFactory;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;

public class CacheHandler
implements HttpHandler {
    private final DirectBufferCache cache;
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CacheHandler(DirectBufferCache cache, HttpHandler next) {
        this.cache = cache;
        this.next = next;
    }

    public CacheHandler(DirectBufferCache cache) {
        this.cache = cache;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        final ResponseCache responseCache = new ResponseCache(this.cache, exchange);
        exchange.putAttachment(ResponseCache.ATTACHMENT_KEY, responseCache);
        exchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                if (!responseCache.isResponseCachable()) {
                    return factory.create();
                }
                AllowedContentEncodings contentEncodings = exchange.getAttachment(AllowedContentEncodings.ATTACHMENT_KEY);
                if (contentEncodings != null && !contentEncodings.isIdentity()) {
                    return factory.create();
                }
                String lengthString = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
                if (lengthString == null) {
                    return factory.create();
                }
                int length = Integer.parseInt(lengthString);
                CachedHttpRequest key = new CachedHttpRequest(exchange);
                DirectBufferCache.CacheEntry entry = CacheHandler.this.cache.add(key, length);
                if (entry == null || entry.buffers().length == 0 || !entry.claimEnable()) {
                    return factory.create();
                }
                if (!entry.reference()) {
                    entry.disable();
                    return factory.create();
                }
                return new ResponseCachingStreamSinkConduit(factory.create(), entry, length);
            }
        });
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CacheHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

