/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.IoCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.Sender;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.CachedHttpRequest;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.DirectBufferCache;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.DateUtils;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ETag;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ETagUtils;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;

public class ResponseCache {
    public static final AttachmentKey<ResponseCache> ATTACHMENT_KEY = AttachmentKey.create(ResponseCache.class);
    private final DirectBufferCache cache;
    private final HttpServerExchange exchange;
    private boolean responseCachable;

    public ResponseCache(DirectBufferCache cache, HttpServerExchange exchange) {
        this.cache = cache;
        this.exchange = exchange;
    }

    public boolean tryServeResponse() {
        return this.tryServeResponse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryServeResponse(boolean markCacheable) {
        ByteBuffer[] buffers;
        CachedHttpRequest key = new CachedHttpRequest(this.exchange);
        DirectBufferCache.CacheEntry entry = this.cache.get(key);
        if (!this.exchange.getRequestMethod().equals(Methods.GET) && !this.exchange.getRequestMethod().equals(Methods.HEAD)) {
            return false;
        }
        if (entry == null) {
            this.responseCachable = markCacheable;
            return false;
        }
        if (!entry.enabled() || !entry.reference()) {
            this.responseCachable = markCacheable;
            return false;
        }
        CachedHttpRequest existingKey = (CachedHttpRequest)entry.key();
        ETag etag = existingKey.getEtag();
        if (!ETagUtils.handleIfMatch(this.exchange, etag, false)) {
            return false;
        }
        if (!ETagUtils.handleIfNoneMatch(this.exchange, etag, true)) {
            this.exchange.setStatusCode(304);
            this.exchange.endExchange();
            return true;
        }
        if (!DateUtils.handleIfUnmodifiedSince(this.exchange, existingKey.getLastModified())) {
            return false;
        }
        if (!DateUtils.handleIfModifiedSince(this.exchange, existingKey.getLastModified())) {
            this.exchange.setStatusCode(304);
            this.exchange.endExchange();
            return true;
        }
        if (existingKey.getContentType() != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, existingKey.getContentType());
        }
        if (existingKey.getContentEncoding() != null && !Headers.IDENTITY.equals(HttpString.tryFromString(existingKey.getContentEncoding()))) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, existingKey.getContentEncoding());
        }
        if (existingKey.getLastModified() != null) {
            this.exchange.getResponseHeaders().put(Headers.LAST_MODIFIED, DateUtils.toDateString(existingKey.getLastModified()));
        }
        if (existingKey.getContentLocation() != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LOCATION, existingKey.getContentLocation());
        }
        if (existingKey.getLanguage() != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, existingKey.getLanguage());
        }
        if (etag != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, etag.toString());
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(entry.size()));
        if (this.exchange.getRequestMethod().equals(Methods.HEAD)) {
            this.exchange.endExchange();
            return true;
        }
        boolean ok = false;
        try {
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = entry.buffers();
            buffers = new ByteBuffer[pooled.length];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = pooled[i].getBuffer().duplicate();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                entry.dereference();
            }
        }
        this.exchange.getResponseSender().send(buffers, (IoCallback)new DereferenceCallback(entry));
        return true;
    }

    boolean isResponseCachable() {
        return this.responseCachable;
    }

    private static class DereferenceCallback
    implements IoCallback {
        private final DirectBufferCache.CacheEntry entry;

        DereferenceCallback(DirectBufferCache.CacheEntry entry) {
            this.entry = entry;
        }

        @Override
        public void onComplete(HttpServerExchange exchange, Sender sender) {
            this.entry.dereference();
            exchange.endExchange();
        }

        @Override
        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
            this.entry.dereference();
            exchange.endExchange();
        }
    }
}

