/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.Handlers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ResponseCodeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.AllowedContentEncodings;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.ContentEncodingRepository;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.GzipEncodingProvider;

public class EncodingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile HttpHandler noEncodingHandler = ResponseCodeHandler.HANDLE_406;
    private final ContentEncodingRepository contentEncodingRepository;

    public EncodingHandler(HttpHandler next, ContentEncodingRepository contentEncodingRepository) {
        this.next = next;
        this.contentEncodingRepository = contentEncodingRepository;
    }

    public EncodingHandler(ContentEncodingRepository contentEncodingRepository) {
        this.contentEncodingRepository = contentEncodingRepository;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        AllowedContentEncodings encodings = this.contentEncodingRepository.getContentEncodings(exchange);
        if (encodings == null || !exchange.isResponseChannelAvailable()) {
            this.next.handleRequest(exchange);
        } else if (encodings.isNoEncodingsAllowed()) {
            this.noEncodingHandler.handleRequest(exchange);
        } else {
            exchange.addResponseWrapper(encodings);
            exchange.putAttachment(AllowedContentEncodings.ATTACHMENT_KEY, encodings);
            this.next.handleRequest(exchange);
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public EncodingHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public HttpHandler getNoEncodingHandler() {
        return this.noEncodingHandler;
    }

    public EncodingHandler setNoEncodingHandler(HttpHandler noEncodingHandler) {
        Handlers.handlerNotNull(noEncodingHandler);
        this.noEncodingHandler = noEncodingHandler;
        return this;
    }

    public String toString() {
        return "compress()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "compress";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new EncodingHandler(handler, new ContentEncodingRepository().addEncodingHandler("gzip", new GzipEncodingProvider(), 100).addEncodingHandler("deflate", new DeflateEncodingProvider(), 10));
                }
            };
        }
    }
}

