/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.IoCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.Sender;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.DirectBufferCache;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.cache.ResponseCachingSender;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.CachingResourceManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.RangeAwareResource;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.Resource;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.DateUtils;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ETag;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.MimeMappings;

public class CachedResource
implements Resource,
RangeAwareResource {
    private final CacheKey cacheKey;
    private final CachingResourceManager cachingResourceManager;
    private final Resource underlyingResource;
    private final boolean directory;
    private final Date lastModifiedDate;
    private final String lastModifiedDateString;
    private final ETag eTag;
    private final String name;
    private volatile long nextMaxAgeCheck;

    public CachedResource(CachingResourceManager cachingResourceManager, Resource underlyingResource, String path) {
        this.cachingResourceManager = cachingResourceManager;
        this.underlyingResource = underlyingResource;
        this.directory = underlyingResource.isDirectory();
        this.lastModifiedDate = underlyingResource.getLastModified();
        this.lastModifiedDateString = this.lastModifiedDate != null ? DateUtils.toDateString(this.lastModifiedDate) : null;
        this.eTag = underlyingResource.getETag();
        this.name = underlyingResource.getName();
        this.cacheKey = new CacheKey(cachingResourceManager, underlyingResource.getCacheKey());
        this.nextMaxAgeCheck = cachingResourceManager.getMaxAge() > 0 ? System.currentTimeMillis() + (long)cachingResourceManager.getMaxAge() : -1L;
    }

    @Override
    public String getPath() {
        return this.underlyingResource.getPath();
    }

    @Override
    public Date getLastModified() {
        return this.lastModifiedDate;
    }

    @Override
    public String getLastModifiedString() {
        return this.lastModifiedDateString;
    }

    @Override
    public ETag getETag() {
        return this.eTag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public List<Resource> list() {
        return this.underlyingResource.list();
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        return this.underlyingResource.getContentType(mimeMappings);
    }

    public void invalidate() {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache != null) {
            dataCache.remove(this.cacheKey);
        }
    }

    public boolean checkStillValid() {
        long time;
        if (this.nextMaxAgeCheck > 0L && (time = System.currentTimeMillis()) > this.nextMaxAgeCheck) {
            this.nextMaxAgeCheck = time + (long)this.cachingResourceManager.getMaxAge();
            if (!this.underlyingResource.getLastModified().equals(this.lastModifiedDate)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            this.underlyingResource.serve(sender, exchange, completionCallback);
            return;
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        Long length = this.getContentLength();
        if (length == null || length > this.cachingResourceManager.getMaxFileSize()) {
            this.underlyingResource.serve(sender, exchange, completionCallback);
            return;
        }
        if (existing == null || !existing.enabled() || !existing.reference()) {
            Sender newSender = sender;
            DirectBufferCache.CacheEntry entry = existing == null ? dataCache.add(this.cacheKey, length.intValue(), this.cachingResourceManager.getMaxAge()) : existing;
            if (entry != null && entry.buffers().length != 0 && entry.claimEnable()) {
                if (entry.reference()) {
                    newSender = new ResponseCachingSender(sender, entry, length);
                } else {
                    entry.disable();
                }
            }
            this.underlyingResource.serve(newSender, exchange, completionCallback);
        } else {
            ByteBuffer[] buffers;
            UndertowLogger.REQUEST_LOGGER.tracef("Serving resource %s from the buffer cache to %s", (Object)this.name, (Object)exchange);
            boolean ok = false;
            try {
                LimitedBufferSlicePool.PooledByteBuffer[] pooled = existing.buffers();
                buffers = new ByteBuffer[pooled.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = pooled[i].getBuffer().duplicate();
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    existing.dereference();
                }
            }
            sender.send(buffers, (IoCallback)new DereferenceCallback(existing, completionCallback));
        }
    }

    @Override
    public Long getContentLength() {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            return this.underlyingResource.getContentLength();
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        if (existing == null || !existing.enabled()) {
            return this.underlyingResource.getContentLength();
        }
        return existing.size();
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey.cacheKey;
    }

    @Override
    public File getFile() {
        return this.underlyingResource.getFile();
    }

    @Override
    public Path getFilePath() {
        return this.underlyingResource.getFilePath();
    }

    @Override
    public File getResourceManagerRoot() {
        return this.underlyingResource.getResourceManagerRoot();
    }

    @Override
    public Path getResourceManagerRootPath() {
        return this.underlyingResource.getResourceManagerRootPath();
    }

    @Override
    public URL getUrl() {
        return this.underlyingResource.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveRange(Sender sender, HttpServerExchange exchange, long start, long end, IoCallback completionCallback) {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            ((RangeAwareResource)this.underlyingResource).serveRange(sender, exchange, start, end, completionCallback);
            return;
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        Long length = this.getContentLength();
        if (length == null || length > this.cachingResourceManager.getMaxFileSize()) {
            ((RangeAwareResource)this.underlyingResource).serveRange(sender, exchange, start, end, completionCallback);
            return;
        }
        if (existing == null || !existing.enabled() || !existing.reference()) {
            ((RangeAwareResource)this.underlyingResource).serveRange(sender, exchange, start, end, completionCallback);
        } else {
            ByteBuffer[] buffers;
            boolean ok = false;
            try {
                LimitedBufferSlicePool.PooledByteBuffer[] pooled = existing.buffers();
                buffers = new ByteBuffer[pooled.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = pooled[i].getBuffer().duplicate();
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    existing.dereference();
                }
            }
            long endTarget = end + 1L;
            long startDec = start;
            long endCount = 0L;
            for (ByteBuffer b : buffers) {
                if (endCount == endTarget) {
                    b.limit(b.position());
                    continue;
                }
                if (endCount + (long)b.remaining() < endTarget) {
                    endCount += (long)b.remaining();
                } else {
                    b.limit((int)((long)b.position() + (endTarget - endCount)));
                    endCount = endTarget;
                }
                if ((long)b.remaining() >= startDec) {
                    b.position((int)((long)b.position() + startDec));
                    startDec = 0L;
                    continue;
                }
                startDec -= (long)b.remaining();
                b.position(b.limit());
            }
            sender.send(buffers, (IoCallback)new DereferenceCallback(existing, completionCallback));
        }
    }

    @Override
    public boolean isRangeSupported() {
        return this.underlyingResource instanceof RangeAwareResource && ((RangeAwareResource)this.underlyingResource).isRangeSupported();
    }

    static final class CacheKey {
        final CachingResourceManager manager;
        final String cacheKey;

        CacheKey(CachingResourceManager manager, String cacheKey) {
            this.manager = manager;
            this.cacheKey = cacheKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey1 = (CacheKey)o;
            if (this.cacheKey != null ? !this.cacheKey.equals(cacheKey1.cacheKey) : cacheKey1.cacheKey != null) {
                return false;
            }
            return !(this.manager != null ? !this.manager.equals(cacheKey1.manager) : cacheKey1.manager != null);
        }

        public int hashCode() {
            int result = this.manager != null ? this.manager.hashCode() : 0;
            result = 31 * result + (this.cacheKey != null ? this.cacheKey.hashCode() : 0);
            return result;
        }
    }

    private static class DereferenceCallback
    implements IoCallback {
        private final DirectBufferCache.CacheEntry entry;
        private final IoCallback callback;

        DereferenceCallback(DirectBufferCache.CacheEntry entry, IoCallback callback) {
            this.entry = entry;
            this.callback = callback;
        }

        @Override
        public void onComplete(HttpServerExchange exchange, Sender sender) {
            try {
                this.entry.dereference();
            }
            finally {
                this.callback.onComplete(exchange, sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
            try {
                this.entry.dereference();
            }
            finally {
                this.callback.onException(exchange, sender, exception);
            }
        }
    }
}

