/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.IoCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.Sender;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.Resource;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.ResourceManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.ResourceSupplier;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.CopyOnWriteMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ETag;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderValues;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.MimeMappings;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.QValueParser;

public class PreCompressedResourceSupplier
implements ResourceSupplier {
    private final ResourceManager resourceManager;
    private final Map<String, String> encodingMap = new CopyOnWriteMap<String, String>();

    public PreCompressedResourceSupplier(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public Resource getResource(HttpServerExchange exchange, String path) throws IOException {
        if (exchange.getRequestHeaders().contains(Headers.RANGE)) {
            return this.resourceManager.getResource(path);
        }
        Resource resource = this.getEncodedResource(exchange, path);
        if (resource == null) {
            return this.resourceManager.getResource(path);
        }
        return resource;
    }

    private Resource getEncodedResource(HttpServerExchange exchange, String path) throws IOException {
        HeaderValues res = exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING);
        if (res == null || res.isEmpty()) {
            return null;
        }
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (List<QValueParser.QValueResult> result : found) {
            for (final QValueParser.QValueResult value : result) {
                String newPath;
                Resource resource;
                final String extension = this.encodingMap.get(value.getValue());
                if (extension == null || (resource = this.resourceManager.getResource(newPath = path + extension)) == null || resource.isDirectory()) continue;
                return new Resource(){

                    @Override
                    public String getPath() {
                        return resource.getPath();
                    }

                    @Override
                    public Date getLastModified() {
                        return resource.getLastModified();
                    }

                    @Override
                    public String getLastModifiedString() {
                        return resource.getLastModifiedString();
                    }

                    @Override
                    public ETag getETag() {
                        return resource.getETag();
                    }

                    @Override
                    public String getName() {
                        return resource.getName();
                    }

                    @Override
                    public boolean isDirectory() {
                        return false;
                    }

                    @Override
                    public List<Resource> list() {
                        return resource.list();
                    }

                    @Override
                    public String getContentType(MimeMappings mimeMappings) {
                        String fileName = resource.getName();
                        String originalFileName = fileName.substring(0, fileName.length() - extension.length());
                        int index = originalFileName.lastIndexOf(46);
                        if (index != -1 && index != originalFileName.length() - 1) {
                            return mimeMappings.getMimeType(originalFileName.substring(index + 1));
                        }
                        return null;
                    }

                    @Override
                    public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
                        exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, value.getValue());
                        resource.serve(sender, exchange, completionCallback);
                    }

                    @Override
                    public Long getContentLength() {
                        return resource.getContentLength();
                    }

                    @Override
                    public String getCacheKey() {
                        return resource.getCacheKey();
                    }

                    @Override
                    public File getFile() {
                        return resource.getFile();
                    }

                    @Override
                    public Path getFilePath() {
                        return resource.getFilePath();
                    }

                    @Override
                    public File getResourceManagerRoot() {
                        return resource.getResourceManagerRoot();
                    }

                    @Override
                    public Path getResourceManagerRootPath() {
                        return resource.getResourceManagerRootPath();
                    }

                    @Override
                    public URL getUrl() {
                        return resource.getUrl();
                    }
                };
            }
        }
        return null;
    }

    public PreCompressedResourceSupplier addEncoding(String encoding, String extension) {
        this.encodingMap.put(encoding, extension);
        return this;
    }

    public PreCompressedResourceSupplier removeEncoding(String encoding) {
        this.encodingMap.remove(encoding);
        return this;
    }
}

