/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowOptions;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ConduitListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.EmptyStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ReadDataStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.AbstractServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatisticsImpl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.Connectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ParseTimeoutUpdater;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp.AjpRequestParseState;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp.AjpRequestParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp.AjpServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp.AjpServerRequestConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp.AjpServerResponseConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.BadRequestException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitStreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.WriteReadyHandler;

final class AjpReadListener
implements ChannelListener<StreamSourceChannel> {
    private static final byte[] CPONG = new byte[]{65, 66, 0, 1, 9};
    private static final byte[] SEND_HEADERS_INTERNAL_SERVER_ERROR_MSG = new byte[]{65, 66, 0, 8, 4, 1, -12, 0, 0, 0, 0, 0};
    private static final byte[] SEND_HEADERS_BAD_REQUEST_MSG = new byte[]{65, 66, 0, 8, 4, 1, -112, 0, 0, 0, 0, 0};
    private static final byte[] END_RESPONSE = new byte[]{65, 66, 0, 2, 5, 0};
    private final AjpServerConnection connection;
    private final String scheme;
    private final boolean recordRequestStartTime;
    private AjpRequestParseState state = new AjpRequestParseState();
    private HttpServerExchange httpServerExchange;
    private volatile int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;
    private final AjpRequestParser parser;
    private final ConnectorStatisticsImpl connectorStatistics;
    private WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel> writeReadyHandler;
    private ParseTimeoutUpdater parseTimeoutUpdater;

    AjpReadListener(AjpServerConnection connection, String scheme, AjpRequestParser parser, ConnectorStatisticsImpl connectorStatistics) {
        this.connection = connection;
        this.scheme = scheme;
        this.parser = parser;
        this.connectorStatistics = connectorStatistics;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 0x100000);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.writeReadyHandler = new WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel>(connection.getChannel().getSinkChannel());
        this.recordRequestStartTime = connection.getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        int requestParseTimeout = connection.getUndertowOptions().get(UndertowOptions.REQUEST_PARSE_TIMEOUT, -1);
        int requestIdleTimeout = connection.getUndertowOptions().get(UndertowOptions.NO_REQUEST_TIMEOUT, -1);
        if (requestIdleTimeout < 0 && requestParseTimeout < 0) {
            this.parseTimeoutUpdater = null;
        } else {
            this.parseTimeoutUpdater = new ParseTimeoutUpdater(connection, requestParseTimeout, requestIdleTimeout);
            connection.addCloseListener(this.parseTimeoutUpdater);
        }
    }

    public void startRequest() {
        this.connection.resetChannel();
        this.state = new AjpRequestParseState();
        this.read = 0;
        if (this.parseTimeoutUpdater != null) {
            this.parseTimeoutUpdater.connectionIdle();
        }
        this.connection.setCurrentExchange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamSourceChannel channel) {
        if (this.connection.getOriginalSinkConduit().isWriteShutdown() || this.connection.getOriginalSourceConduit().isReadShutdown()) {
            IoUtils.safeClose((Closeable)this.connection);
            channel.suspendReads();
            return;
        }
        PooledByteBuffer existing = this.connection.getExtraBytes();
        PooledByteBuffer pooled = existing == null ? this.connection.getByteBufferPool().allocate() : existing;
        ByteBuffer buffer = pooled.getBuffer();
        boolean free = true;
        boolean bytesRead = false;
        try {
            do {
                int res;
                if (existing == null) {
                    buffer.clear();
                    res = channel.read(buffer);
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (bytesRead && this.parseTimeoutUpdater != null) {
                        this.parseTimeoutUpdater.failedParse();
                    }
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set(this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    channel.shutdownReads();
                    ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
                    responseChannel.shutdownWrites();
                    IoUtils.safeClose((Closeable)this.connection);
                    return;
                }
                bytesRead = true;
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                if (this.httpServerExchange == null) {
                    this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
                }
                this.parser.parse(buffer, this.state, this.httpServerExchange);
                this.read += begin - buffer.remaining();
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes(pooled);
                }
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)this.connection);
                return;
            } while (!this.state.isComplete());
            if (this.parseTimeoutUpdater != null) {
                this.parseTimeoutUpdater.requestStarted();
            }
            if (this.state.prefix != 2) {
                if (this.state.prefix == 10) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPING, sending CPONG");
                    this.handleCPing();
                } else if (this.state.prefix == 9) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPONG, starting next request");
                    this.state = new AjpRequestParseState();
                    channel.getReadSetter().set(this);
                    channel.resumeReads();
                } else {
                    UndertowLogger.REQUEST_LOGGER.ignoringAjpRequestWithPrefixCode(this.state.prefix);
                    IoUtils.safeClose((Closeable)this.connection);
                }
                return;
            }
            channel.getReadSetter().set(null);
            channel.suspendReads();
            final HttpServerExchange httpServerExchange = this.httpServerExchange;
            AjpServerResponseConduit responseConduit = new AjpServerResponseConduit(this.connection.getChannel().getSinkChannel().getConduit(), this.connection.getByteBufferPool(), httpServerExchange, (ConduitListener<? super AjpServerResponseConduit>)new ConduitListener<AjpServerResponseConduit>(){

                @Override
                public void handleEvent(AjpServerResponseConduit channel) {
                    Connectors.terminateResponse(httpServerExchange);
                }
            }, httpServerExchange.getRequestMethod().equals(Methods.HEAD));
            this.connection.getChannel().getSinkChannel().setConduit(responseConduit);
            this.connection.getChannel().getSourceChannel().setConduit(this.createSourceConduit(this.connection.getChannel().getSourceChannel().getConduit(), responseConduit, httpServerExchange));
            responseConduit.setWriteReadyHandler(this.writeReadyHandler);
            this.connection.setSSLSessionInfo(this.state.createSslSessionInfo());
            httpServerExchange.setSourceAddress(this.state.createPeerAddress());
            httpServerExchange.setDestinationAddress(this.state.createDestinationAddress());
            if (this.scheme != null) {
                httpServerExchange.setRequestScheme(this.scheme);
            }
            if (this.state.attributes != null) {
                httpServerExchange.putAttachment(HttpServerExchange.REQUEST_ATTRIBUTES, this.state.attributes);
            }
            AjpRequestParseState oldState = this.state;
            this.state = null;
            this.httpServerExchange = null;
            httpServerExchange.setPersistent(true);
            if (this.recordRequestStartTime) {
                Connectors.setRequestStartTime(httpServerExchange);
            }
            this.connection.setCurrentExchange(httpServerExchange);
            if (this.connectorStatistics != null) {
                this.connectorStatistics.setup(httpServerExchange);
            }
            if (!Connectors.areRequestHeadersValid(httpServerExchange.getRequestHeaders())) {
                oldState.badRequest = true;
                UndertowLogger.REQUEST_IO_LOGGER.debugf("Invalid AJP request from %s, request contained invalid headers", (Object)this.connection.getPeerAddress());
            }
            if (oldState.badRequest) {
                httpServerExchange.setStatusCode(400);
                httpServerExchange.endExchange();
                IoUtils.safeClose((Closeable)this.connection);
            } else {
                Connectors.executeRootHandler(this.connection.getRootHandler(), httpServerExchange);
            }
        }
        catch (BadRequestException e) {
            UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(e);
            this.handleBadRequest();
            IoUtils.safeClose((Closeable)this.connection);
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            this.handleInternalServerError();
            IoUtils.safeClose((Closeable)this.connection);
        }
        catch (Throwable t2) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t2);
            this.handleInternalServerError();
            IoUtils.safeClose((Closeable)this.connection);
        }
        finally {
            if (free) {
                pooled.close();
            }
        }
    }

    private void handleInternalServerError() {
        this.sendMessages(SEND_HEADERS_INTERNAL_SERVER_ERROR_MSG, END_RESPONSE);
    }

    private void handleBadRequest() {
        this.sendMessages(SEND_HEADERS_BAD_REQUEST_MSG, END_RESPONSE);
    }

    private void handleCPing() {
        if (this.sendMessages(new byte[][]{CPONG})) {
            this.handleEvent(this.connection.getChannel().getSourceChannel());
        }
    }

    private boolean sendMessages(byte[] ... rawMessages) {
        this.state = new AjpRequestParseState();
        final StreamConnection underlyingChannel = this.connection.getChannel();
        underlyingChannel.getSourceChannel().suspendReads();
        int bufferSize = 0;
        for (int i = 0; i < rawMessages.length; ++i) {
            bufferSize += rawMessages[i].length;
        }
        final ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (int i = 0; i < rawMessages.length; ++i) {
            buffer.put(rawMessages[i]);
        }
        buffer.flip();
        try {
            do {
                int res;
                if ((res = underlyingChannel.getSinkChannel().write(buffer)) != 0) continue;
                underlyingChannel.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)new ChannelListener<ConduitStreamSinkChannel>(){

                    @Override
                    public void handleEvent(ConduitStreamSinkChannel channel) {
                        do {
                            try {
                                int res = channel.write(buffer);
                                if (res == 0) {
                                    return;
                                }
                            }
                            catch (IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose((Closeable)AjpReadListener.this.connection);
                            }
                        } while (buffer.hasRemaining());
                        channel.suspendWrites();
                        AjpReadListener.this.handleEvent(underlyingChannel.getSourceChannel());
                    }
                });
                underlyingChannel.getSinkChannel().resumeWrites();
                return false;
            } while (buffer.hasRemaining());
            return true;
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)this.connection);
            return false;
        }
    }

    public void exchangeComplete(HttpServerExchange exchange) {
        if (!exchange.isUpgrade() && exchange.isPersistent()) {
            this.startRequest();
            ConduitStreamSourceChannel channel = ((AjpServerConnection)exchange.getConnection()).getChannel().getSourceChannel();
            channel.getReadSetter().set(this);
            channel.wakeupReads();
        } else if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)exchange.getConnection());
        }
    }

    private StreamSourceConduit createSourceConduit(StreamSourceConduit underlyingConduit, AjpServerResponseConduit responseConduit, final HttpServerExchange exchange) throws BadRequestException {
        Long length;
        boolean hasTransferEncoding;
        ReadDataStreamSourceConduit conduit = new ReadDataStreamSourceConduit(underlyingConduit, (AbstractServerConnection)exchange.getConnection());
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        HttpString transferEncoding = Headers.IDENTITY;
        String teHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        boolean bl = hasTransferEncoding = teHeader != null;
        if (hasTransferEncoding) {
            transferEncoding = new HttpString(teHeader);
        }
        String requestContentLength = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (hasTransferEncoding && !transferEncoding.equals(Headers.IDENTITY)) {
            length = null;
        } else if (requestContentLength != null) {
            try {
                long contentLength = Long.parseLong(requestContentLength);
                if (contentLength == 0L) {
                    UndertowLogger.REQUEST_LOGGER.trace("No content, starting next request");
                    Connectors.terminateRequest(this.httpServerExchange);
                    return new EmptyStreamSourceConduit(conduit.getReadThread());
                }
                length = contentLength;
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid Content-Length header", e);
            }
        } else {
            UndertowLogger.REQUEST_LOGGER.trace("No content length or transfer coding, starting next request");
            Connectors.terminateRequest(exchange);
            return new EmptyStreamSourceConduit(conduit.getReadThread());
        }
        return new AjpServerRequestConduit(conduit, exchange, responseConduit, length, (ConduitListener<? super AjpServerRequestConduit>)new ConduitListener<AjpServerRequestConduit>(){

            @Override
            public void handleEvent(AjpServerRequestConduit channel) {
                Connectors.terminateRequest(exchange);
            }
        });
    }
}

