/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.impl.ExternalAuthenticationMechanism;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.Connectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.ajp.AjpRequestParseState;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.BadRequestException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ParameterLimitException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.URLUtils;

public class AjpRequestParser {
    private final String encoding;
    private final boolean doDecode;
    private final boolean slashDecodingFlag;
    private final int maxParameters;
    private final int maxHeaders;
    private StringBuilder decodeBuffer;
    private final boolean allowUnescapedCharactersInUrl;
    private final Pattern allowedRequestAttributesPattern;
    private static final HttpString[] HTTP_HEADERS;
    public static final int FORWARD_REQUEST = 2;
    public static final int CPONG = 9;
    public static final int CPING = 10;
    public static final int SHUTDOWN = 7;
    private static final HttpString[] HTTP_METHODS;
    private static final String[] ATTRIBUTES;
    private static final Set<String> ATTR_SET;
    public static final String QUERY_STRING = "query_string";
    public static final String SSL_CERT = "ssl_cert";
    public static final String CONTEXT = "context";
    public static final String SERVLET_PATH = "servlet_path";
    public static final String REMOTE_USER = "remote_user";
    public static final String AUTH_TYPE = "auth_type";
    public static final String ROUTE = "route";
    public static final String SSL_CIPHER = "ssl_cipher";
    public static final String SSL_SESSION = "ssl_session";
    public static final String REQ_ATTRIBUTE = "req_attribute";
    public static final String SSL_KEY_SIZE = "ssl_key_size";
    public static final String SECRET = "secret";
    public static final String STORED_METHOD = "stored_method";
    public static final String AJP_REMOTE_PORT = "AJP_REMOTE_PORT";
    public static final int STRING_LENGTH_MASK = Integer.MIN_VALUE;

    public AjpRequestParser(String encoding, boolean doDecode, int maxParameters, int maxHeaders, boolean slashDecodingFlag, boolean allowUnescapedCharactersInUrl) {
        this(encoding, doDecode, maxParameters, maxHeaders, slashDecodingFlag, allowUnescapedCharactersInUrl, null);
    }

    public AjpRequestParser(String encoding, boolean doDecode, int maxParameters, int maxHeaders, boolean slashDecodingFlag, boolean allowUnescapedCharactersInUrl, String allowedRequestAttributesPattern) {
        this.encoding = encoding;
        this.doDecode = doDecode;
        this.maxParameters = maxParameters;
        this.maxHeaders = maxHeaders;
        this.slashDecodingFlag = slashDecodingFlag;
        this.allowUnescapedCharactersInUrl = allowUnescapedCharactersInUrl;
        this.allowedRequestAttributesPattern = allowedRequestAttributesPattern != null && !allowedRequestAttributesPattern.isEmpty() ? Pattern.compile(allowedRequestAttributesPattern) : null;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer buf, AjpRequestParseState state, HttpServerExchange exchange) throws IOException, BadRequestException {
        if (!buf.hasRemaining()) {
            return;
        }
        switch (state.state) {
            case 0: {
                result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    return;
                }
                if (result.value != 4660) {
                    throw new BadRequestException(UndertowMessages.MESSAGES.wrongMagicNumber(result.value));
                }
            }
            case 2: {
                result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 2;
                    return;
                }
                state.dataSize = result.value;
            }
            case 3: {
                if (!buf.hasRemaining()) {
                    state.state = 3;
                    return;
                }
                state.prefix = prefix = buf.get();
                if (prefix != 2) {
                    state.state = 15;
                    return;
                }
            }
            case 4: {
                if (!buf.hasRemaining()) {
                    state.state = 4;
                    return;
                }
                method = buf.get();
                if (method <= 0 || method >= 28) ** GOTO lbl33
                exchange.setRequestMethod(AjpRequestParser.HTTP_METHODS[method]);
                ** GOTO lbl35
lbl33:
                // 1 sources

                if ((method & 255) != 255) {
                    throw new BadRequestException("Unknown method type " + method);
                }
            }
lbl35:
            // 4 sources

            case 5: {
                result = this.parseString(buf, state, StringType.OTHER);
                if (result.readComplete) {
                    exchange.setProtocol(HttpString.tryFromString(result.value));
                } else {
                    state.state = 5;
                    return;
                }
            }
            case 6: {
                result = this.parseString(buf, state, StringType.URL);
                if (result.readComplete) {
                    colon = result.value.indexOf(59);
                    if (colon == -1) {
                        res = this.decode(result.value, result.containsUrlCharacters);
                        if (result.containsUnencodedCharacters) {
                            exchange.setRequestURI(res);
                        } else {
                            exchange.setRequestURI(result.value);
                        }
                        exchange.setRequestPath(res);
                        exchange.setRelativePath(res);
                    } else {
                        resBuffer = new StringBuffer();
                        pathParamParsingIndex = 0;
                        try {
                            do {
                                url = result.value.substring(pathParamParsingIndex, colon);
                                resBuffer.append(this.decode(url, result.containsUrlCharacters));
                                pathParamParsingIndex = colon + 1 + URLUtils.parsePathParams(result.value.substring(colon + 1), exchange, this.encoding, this.doDecode != false && result.containsUrlCharacters != false, this.maxParameters);
                                colon = result.value.indexOf(59, pathParamParsingIndex + 1);
                            } while (pathParamParsingIndex < result.value.length() && colon != -1);
                        }
                        catch (ParameterLimitException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(e);
                            state.badRequest = true;
                        }
                        if (pathParamParsingIndex < result.value.length()) {
                            url = result.value.substring(pathParamParsingIndex);
                            resBuffer.append(this.decode(url, result.containsUrlCharacters));
                        }
                        res = resBuffer.toString();
                        if (result.containsUnencodedCharacters) {
                            exchange.setRequestURI(res);
                        } else {
                            exchange.setRequestURI(result.value);
                        }
                        exchange.setRequestPath(res);
                        exchange.setRelativePath(res);
                    }
                } else {
                    state.state = 6;
                    return;
                }
            }
            case 7: {
                result = this.parseString(buf, state, StringType.OTHER);
                if (result.readComplete) {
                    state.remoteAddress = result.value;
                } else {
                    state.state = 7;
                    return;
                }
            }
            case 8: {
                result = this.parseString(buf, state, StringType.OTHER);
                if (!result.readComplete) {
                    state.state = 8;
                    return;
                }
            }
            case 9: {
                result = this.parseString(buf, state, StringType.OTHER);
                if (result.readComplete) {
                    state.serverAddress = result.value;
                } else {
                    state.state = 9;
                    return;
                }
            }
            case 10: {
                result = this.parse16BitInteger(buf, state);
                if (result.readComplete) {
                    state.serverPort = result.value;
                } else {
                    state.state = 10;
                    return;
                }
            }
            case 11: {
                if (!buf.hasRemaining()) {
                    state.state = 11;
                    return;
                }
                isSsl = buf.get();
                if (isSsl != 0) {
                    exchange.setRequestScheme("https");
                } else {
                    exchange.setRequestScheme("http");
                }
            }
            case 12: {
                result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 12;
                    return;
                }
                state.numHeaders = result.value;
                if (state.numHeaders > this.maxHeaders) {
                    UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(new BadRequestException(UndertowMessages.MESSAGES.tooManyHeaders(this.maxHeaders)));
                    state.badRequest = true;
                }
            }
            case 13: {
                for (readHeaders = state.readHeaders; readHeaders < state.numHeaders; ++readHeaders) {
                    if (state.currentHeader == null) {
                        result = this.parseString(buf, state, StringType.HEADER);
                        if (!result.readComplete) {
                            state.state = 13;
                            state.readHeaders = readHeaders;
                            return;
                        }
                        if (result.header != null) {
                            state.currentHeader = result.header;
                        } else {
                            state.currentHeader = HttpString.tryFromString(result.value);
                            Connectors.verifyToken(state.currentHeader);
                        }
                    }
                    result = this.parseString(buf, state, StringType.OTHER);
                    if (!result.readComplete) {
                        state.state = 13;
                        state.readHeaders = readHeaders;
                        return;
                    }
                    if (!state.badRequest) {
                        exchange.getRequestHeaders().add(state.currentHeader, result.value);
                    }
                    state.currentHeader = null;
                }
            }
            case 14: {
                while (true) {
                    if (state.currentAttribute == null && state.currentIntegerPart == -1) {
                        if (!buf.hasRemaining()) {
                            state.state = 14;
                            return;
                        }
                        val = 255 & buf.get();
                        if (val == 255) {
                            state.state = 15;
                            return;
                        }
                        if (val == 10) {
                            state.currentIntegerPart = 1;
                        } else {
                            if (val == 0 || val >= AjpRequestParser.ATTRIBUTES.length) continue;
                            state.currentAttribute = AjpRequestParser.ATTRIBUTES[val];
                        }
                    }
                    if (state.currentIntegerPart == 1) {
                        result = this.parseString(buf, state, StringType.OTHER);
                        if (!result.readComplete) {
                            state.state = 14;
                            return;
                        }
                        state.currentAttribute = result.value;
                        state.currentIntegerPart = -1;
                    }
                    decodingAlreadyDone = false;
                    if (state.currentAttribute.equals("ssl_key_size")) {
                        resultHolder = this.parse16BitInteger(buf, state);
                        if (!resultHolder.readComplete) {
                            state.state = 14;
                            return;
                        }
                        result = Integer.toString(resultHolder.value);
                    } else {
                        resultHolder = this.parseString(buf, state, state.currentAttribute.equals("query_string") != false ? StringType.QUERY_STRING : StringType.OTHER);
                        if (!resultHolder.readComplete) {
                            state.state = 14;
                            return;
                        }
                        if (resultHolder.containsUnencodedCharacters) {
                            result = this.decode(resultHolder.value, true);
                            decodingAlreadyDone = true;
                        } else {
                            result = resultHolder.value;
                        }
                    }
                    if (state.currentAttribute.equals("query_string")) {
                        resultAsQueryString = result == null ? "" : result;
                        exchange.setQueryString(resultAsQueryString);
                        try {
                            URLUtils.parseQueryString(resultAsQueryString, exchange, this.encoding, this.doDecode != false && decodingAlreadyDone == false, this.maxParameters);
                        }
                        catch (IllegalArgumentException | ParameterLimitException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(e);
                            state.badRequest = true;
                        }
                    } else if (state.currentAttribute.equals("remote_user")) {
                        exchange.putAttachment(ExternalAuthenticationMechanism.EXTERNAL_PRINCIPAL, result);
                        exchange.putAttachment(HttpServerExchange.REMOTE_USER, result);
                    } else if (state.currentAttribute.equals("auth_type")) {
                        exchange.putAttachment(ExternalAuthenticationMechanism.EXTERNAL_AUTHENTICATION_TYPE, result);
                    } else if (state.currentAttribute.equals("stored_method")) {
                        requestMethod = new HttpString(result);
                        Connectors.verifyToken(requestMethod);
                        exchange.setRequestMethod(requestMethod);
                    } else if (state.currentAttribute.equals("AJP_REMOTE_PORT")) {
                        state.remotePort = Integer.parseInt(result);
                    } else if (state.currentAttribute.equals("ssl_session")) {
                        state.sslSessionId = result;
                    } else if (state.currentAttribute.equals("ssl_cipher")) {
                        state.sslCipher = result;
                    } else if (state.currentAttribute.equals("ssl_cert")) {
                        state.sslCert = result;
                    } else if (state.currentAttribute.equals("ssl_key_size")) {
                        state.sslKeySize = result;
                    } else {
                        if (state.attributes == null) {
                            state.attributes = new TreeMap<String, String>();
                        }
                        if (AjpRequestParser.ATTR_SET.contains(state.currentAttribute)) {
                            state.attributes.put(state.currentAttribute, result);
                        } else if (this.allowedRequestAttributesPattern != null && (m = this.allowedRequestAttributesPattern.matcher(state.currentAttribute)).matches()) {
                            state.attributes.put(state.currentAttribute, result);
                        }
                    }
                    state.currentAttribute = null;
                }
            }
        }
        state.state = 15;
    }

    private String decode(String url, boolean containsUrlCharacters) throws UnsupportedEncodingException {
        if (this.doDecode && containsUrlCharacters) {
            try {
                if (this.decodeBuffer == null) {
                    this.decodeBuffer = new StringBuilder();
                }
                return URLUtils.decode(url, this.encoding, this.slashDecodingFlag, false, this.decodeBuffer);
            }
            catch (Exception e) {
                throw UndertowMessages.MESSAGES.failedToDecodeURL(url, this.encoding, e);
            }
        }
        return url;
    }

    protected HttpString headers(int offset) {
        return HTTP_HEADERS[offset];
    }

    protected IntegerHolder parse16BitInteger(ByteBuffer buf, AjpRequestParseState state) {
        if (!buf.hasRemaining()) {
            return new IntegerHolder(-1, false);
        }
        int number = state.currentIntegerPart;
        if (number == -1) {
            number = buf.get() & 0xFF;
        }
        if (buf.hasRemaining()) {
            byte b = buf.get();
            int result = ((0xFF & number) << 8) + (b & 0xFF);
            state.currentIntegerPart = -1;
            return new IntegerHolder(result, true);
        }
        state.currentIntegerPart = number;
        return new IntegerHolder(-1, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected StringHolder parseString(ByteBuffer buf, AjpRequestParseState state, StringType type) throws UnsupportedEncodingException, BadRequestException {
        int number;
        boolean containsUrlCharacters = state.containsUrlCharacters;
        boolean containsUnencodedUrlCharacters = state.containsUnencodedUrlCharacters;
        if (!buf.hasRemaining()) {
            return new StringHolder(null, false, false, false);
        }
        int stringLength = state.stringLength;
        if (stringLength == -1) {
            number = buf.get() & 0xFF;
            if (!buf.hasRemaining()) {
                state.stringLength = number | Integer.MIN_VALUE;
                return new StringHolder(null, false, false, false);
            }
            byte b = buf.get();
            stringLength = ((0xFF & number) << 8) + (b & 0xFF);
        } else if ((stringLength & Integer.MIN_VALUE) != 0) {
            number = stringLength & Integer.MAX_VALUE;
            stringLength = ((0xFF & number) << 8) + (buf.get() & 0xFF);
        }
        if (type == StringType.HEADER && (stringLength & 0xFF00) != 0) {
            state.stringLength = -1;
            return new StringHolder(this.headers(stringLength & 0xFF));
        }
        if (stringLength == 65535) {
            state.stringLength = -1;
            return new StringHolder(null, true, false, false);
        }
        for (int length = state.getCurrentStringLength(); length < stringLength; ++length) {
            if (!buf.hasRemaining()) {
                state.stringLength = stringLength;
                state.containsUrlCharacters = containsUrlCharacters;
                state.containsUnencodedUrlCharacters = containsUnencodedUrlCharacters;
                return new StringHolder(null, false, false, false);
            }
            byte c = buf.get();
            if (type == StringType.QUERY_STRING && (c == 43 || c == 37 || c < 0)) {
                if (c < 0) {
                    if (!this.allowUnescapedCharactersInUrl) {
                        throw new BadRequestException();
                    }
                    containsUnencodedUrlCharacters = true;
                }
                containsUrlCharacters = true;
            } else if (type == StringType.URL && (c == 37 || c < 0)) {
                if (c < 0) {
                    if (!this.allowUnescapedCharactersInUrl) {
                        throw new BadRequestException();
                    }
                    containsUnencodedUrlCharacters = true;
                }
                containsUrlCharacters = true;
            }
            state.addStringByte(c);
        }
        if (buf.hasRemaining()) {
            buf.get();
            String value = state.getStringAndClear();
            state.stringLength = -1;
            state.containsUrlCharacters = false;
            state.containsUnencodedUrlCharacters = containsUnencodedUrlCharacters;
            return new StringHolder(value, true, containsUrlCharacters, containsUnencodedUrlCharacters);
        }
        state.stringLength = stringLength;
        state.containsUrlCharacters = containsUrlCharacters;
        state.containsUnencodedUrlCharacters = containsUnencodedUrlCharacters;
        return new StringHolder(null, false, false, false);
    }

    static {
        HTTP_METHODS = new HttpString[28];
        AjpRequestParser.HTTP_METHODS[1] = Methods.OPTIONS;
        AjpRequestParser.HTTP_METHODS[2] = Methods.GET;
        AjpRequestParser.HTTP_METHODS[3] = Methods.HEAD;
        AjpRequestParser.HTTP_METHODS[4] = Methods.POST;
        AjpRequestParser.HTTP_METHODS[5] = Methods.PUT;
        AjpRequestParser.HTTP_METHODS[6] = Methods.DELETE;
        AjpRequestParser.HTTP_METHODS[7] = Methods.TRACE;
        AjpRequestParser.HTTP_METHODS[8] = Methods.PROPFIND;
        AjpRequestParser.HTTP_METHODS[9] = Methods.PROPPATCH;
        AjpRequestParser.HTTP_METHODS[10] = Methods.MKCOL;
        AjpRequestParser.HTTP_METHODS[11] = Methods.COPY;
        AjpRequestParser.HTTP_METHODS[12] = Methods.MOVE;
        AjpRequestParser.HTTP_METHODS[13] = Methods.LOCK;
        AjpRequestParser.HTTP_METHODS[14] = Methods.UNLOCK;
        AjpRequestParser.HTTP_METHODS[15] = Methods.ACL;
        AjpRequestParser.HTTP_METHODS[16] = Methods.REPORT;
        AjpRequestParser.HTTP_METHODS[17] = Methods.VERSION_CONTROL;
        AjpRequestParser.HTTP_METHODS[18] = Methods.CHECKIN;
        AjpRequestParser.HTTP_METHODS[19] = Methods.CHECKOUT;
        AjpRequestParser.HTTP_METHODS[20] = Methods.UNCHECKOUT;
        AjpRequestParser.HTTP_METHODS[21] = Methods.SEARCH;
        AjpRequestParser.HTTP_METHODS[22] = Methods.MKWORKSPACE;
        AjpRequestParser.HTTP_METHODS[23] = Methods.UPDATE;
        AjpRequestParser.HTTP_METHODS[24] = Methods.LABEL;
        AjpRequestParser.HTTP_METHODS[25] = Methods.MERGE;
        AjpRequestParser.HTTP_METHODS[26] = Methods.BASELINE_CONTROL;
        AjpRequestParser.HTTP_METHODS[27] = Methods.MKACTIVITY;
        HTTP_HEADERS = new HttpString[15];
        AjpRequestParser.HTTP_HEADERS[1] = Headers.ACCEPT;
        AjpRequestParser.HTTP_HEADERS[2] = Headers.ACCEPT_CHARSET;
        AjpRequestParser.HTTP_HEADERS[3] = Headers.ACCEPT_ENCODING;
        AjpRequestParser.HTTP_HEADERS[4] = Headers.ACCEPT_LANGUAGE;
        AjpRequestParser.HTTP_HEADERS[5] = Headers.AUTHORIZATION;
        AjpRequestParser.HTTP_HEADERS[6] = Headers.CONNECTION;
        AjpRequestParser.HTTP_HEADERS[7] = Headers.CONTENT_TYPE;
        AjpRequestParser.HTTP_HEADERS[8] = Headers.CONTENT_LENGTH;
        AjpRequestParser.HTTP_HEADERS[9] = Headers.COOKIE;
        AjpRequestParser.HTTP_HEADERS[10] = Headers.COOKIE2;
        AjpRequestParser.HTTP_HEADERS[11] = Headers.HOST;
        AjpRequestParser.HTTP_HEADERS[12] = Headers.PRAGMA;
        AjpRequestParser.HTTP_HEADERS[13] = Headers.REFERER;
        AjpRequestParser.HTTP_HEADERS[14] = Headers.USER_AGENT;
        ATTRIBUTES = new String[14];
        AjpRequestParser.ATTRIBUTES[1] = CONTEXT;
        AjpRequestParser.ATTRIBUTES[2] = SERVLET_PATH;
        AjpRequestParser.ATTRIBUTES[3] = REMOTE_USER;
        AjpRequestParser.ATTRIBUTES[4] = AUTH_TYPE;
        AjpRequestParser.ATTRIBUTES[5] = QUERY_STRING;
        AjpRequestParser.ATTRIBUTES[6] = ROUTE;
        AjpRequestParser.ATTRIBUTES[7] = SSL_CERT;
        AjpRequestParser.ATTRIBUTES[8] = SSL_CIPHER;
        AjpRequestParser.ATTRIBUTES[9] = SSL_SESSION;
        AjpRequestParser.ATTRIBUTES[10] = REQ_ATTRIBUTE;
        AjpRequestParser.ATTRIBUTES[11] = SSL_KEY_SIZE;
        AjpRequestParser.ATTRIBUTES[12] = SECRET;
        AjpRequestParser.ATTRIBUTES[13] = STORED_METHOD;
        ATTR_SET = new HashSet<String>(Arrays.asList(ATTRIBUTES));
    }

    static enum StringType {
        HEADER,
        URL,
        QUERY_STRING,
        OTHER;

    }

    protected static class StringHolder {
        public final String value;
        public final HttpString header;
        final boolean readComplete;
        final boolean containsUrlCharacters;
        final boolean containsUnencodedCharacters;

        private StringHolder(String value, boolean readComplete, boolean containsUrlCharacters, boolean containsUnencodedCharacters) {
            this.value = value;
            this.readComplete = readComplete;
            this.containsUrlCharacters = containsUrlCharacters;
            this.containsUnencodedCharacters = containsUnencodedCharacters;
            this.header = null;
        }

        private StringHolder(HttpString value) {
            this.value = null;
            this.readComplete = true;
            this.header = value;
            this.containsUrlCharacters = false;
            this.containsUnencodedCharacters = false;
        }
    }

    protected static class IntegerHolder {
        public final int value;
        public final boolean readComplete;

        private IntegerHolder(int value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
        }
    }
}

