/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowOptions;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.BytesReceivedStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.BytesSentStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.IdleTimeoutConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ReadTimeoutStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.WriteTimeoutStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatistics;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatisticsImpl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.DelegateOpenListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.XnioByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpReadListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpRequestParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpServerConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;

public final class HttpOpenListener
implements ChannelListener<StreamConnection>,
DelegateOpenListener {
    private final Set<HttpServerConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ByteBufferPool bufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile HttpRequestParser parser;
    private volatile boolean statisticsEnabled;
    private final ConnectorStatisticsImpl connectorStatistics;

    @Deprecated
    public HttpOpenListener(Pool<ByteBuffer> pool) {
        this(pool, OptionMap.EMPTY);
    }

    @Deprecated
    public HttpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this(new XnioByteBufferPool(pool), undertowOptions);
    }

    public HttpOpenListener(ByteBufferPool pool) {
        this(pool, OptionMap.EMPTY);
    }

    public HttpOpenListener(ByteBufferPool pool, OptionMap undertowOptions) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        PooledByteBuffer buf = pool.allocate();
        this.bufferSize = buf.getBuffer().remaining();
        buf.close();
        this.parser = HttpRequestParser.instance(undertowOptions);
        this.connectorStatistics = new ConnectorStatisticsImpl();
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        this.handleEvent(channel, null);
    }

    @Override
    public void handleEvent(StreamConnection channel, PooledByteBuffer buffer) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        try {
            Integer writeTimeout;
            Integer readTimeout = channel.getOption(Options.READ_TIMEOUT);
            Integer idle = this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
            if (idle != null) {
                IdleTimeoutConduit conduit = new IdleTimeoutConduit(channel);
                channel.getSourceChannel().setConduit(conduit);
                channel.getSinkChannel().setConduit(conduit);
            }
            if (readTimeout != null && readTimeout > 0) {
                channel.getSourceChannel().setConduit(new ReadTimeoutStreamSourceConduit(channel.getSourceChannel().getConduit(), channel, this));
            }
            if ((writeTimeout = channel.getOption(Options.WRITE_TIMEOUT)) != null && writeTimeout > 0) {
                channel.getSinkChannel().setConduit(new WriteTimeoutStreamSinkConduit(channel.getSinkChannel().getConduit(), channel, this));
            }
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)channel);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
        catch (Throwable t2) {
            IoUtils.safeClose((Closeable)channel);
            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t2);
        }
        if (this.statisticsEnabled) {
            channel.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(channel.getSinkChannel().getConduit(), this.connectorStatistics.sentAccumulator()));
            channel.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(channel.getSourceChannel().getConduit(), this.connectorStatistics.receivedAccumulator()));
        }
        final HttpServerConnection connection = new HttpServerConnection(channel, this.bufferPool, this.rootHandler, this.undertowOptions, this.bufferSize, this.statisticsEnabled ? this.connectorStatistics : null);
        HttpReadListener readListener = new HttpReadListener(connection, this.parser, this.statisticsEnabled ? this.connectorStatistics : null);
        if (buffer != null) {
            if (buffer.getBuffer().hasRemaining()) {
                connection.setExtraBytes(buffer);
            } else {
                buffer.close();
            }
        }
        if (this.connectorStatistics != null && this.statisticsEnabled) {
            this.connectorStatistics.incrementConnectionCount();
        }
        this.connections.add(connection);
        connection.addCloseListener(new ServerConnection.CloseListener(){

            @Override
            public void closed(ServerConnection c) {
                HttpOpenListener.this.connections.remove(connection);
            }
        });
        connection.setReadListener(readListener);
        readListener.newRequest();
        channel.getSourceChannel().setReadListener(readListener);
        readListener.handleEvent(channel.getSourceChannel());
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.parser = HttpRequestParser.instance(undertowOptions);
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            return this.connectorStatistics;
        }
        return null;
    }

    @Override
    public void closeConnections() {
        for (final HttpServerConnection i : this.connections) {
            i.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    IoUtils.safeClose((Closeable)i);
                }
            });
        }
    }
}

