/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http2;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowOptions;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.HeadStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Channel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2DataStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConduitWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatisticsImpl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.Connectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpAttachments;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpContinue;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpRequestParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http2.Http2ServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http2.Http2SslSessionInfo;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ConduitFactory;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderValues;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ImmediatePooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ParameterLimitException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Protocols;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.URLUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.Channels;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;

public class Http2ReceiveListener
implements ChannelListener<Http2Channel> {
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final boolean decode;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean slashDecodingFlag;
    private final int bufferSize;
    private final int maxParameters;
    private final boolean recordRequestStartTime;
    private final boolean allowUnescapedCharactersInUrl;
    private final ConnectorStatisticsImpl connectorStatistics;

    public Http2ReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize, ConnectorStatisticsImpl connectorStatistics) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.connectorStatistics = connectorStatistics;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.slashDecodingFlag = URLUtils.getSlashDecodingFlag(undertowOptions);
        this.decode = undertowOptions.get(UndertowOptions.DECODE_URL, true);
        this.maxParameters = undertowOptions.get(UndertowOptions.MAX_PARAMETERS, 1000);
        this.recordRequestStartTime = undertowOptions.get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? undertowOptions.get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name()) : null;
        this.allowUnescapedCharactersInUrl = undertowOptions.get(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, false);
    }

    @Override
    public void handleEvent(Http2Channel channel) {
        try {
            AbstractHttp2StreamSourceChannel frame = (AbstractHttp2StreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof Http2StreamSourceChannel) {
                this.handleRequests(channel, (Http2StreamSourceChannel)frame);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)channel);
        }
        catch (Throwable t2) {
            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t2);
            IoUtils.safeClose((Closeable)channel);
        }
    }

    private void handleRequests(Http2Channel channel, Http2StreamSourceChannel frame) {
        Http2StreamSourceChannel dataChannel = frame;
        Http2ServerConnection connection = new Http2ServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize, this.rootHandler);
        if (!this.checkRequestHeaders(dataChannel.getHeaders())) {
            channel.sendRstStream(frame.getStreamId(), 1);
            try {
                Channels.drain(frame, Long.MAX_VALUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        final HttpServerExchange exchange = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
        dataChannel.setTrailersHandler(new Http2StreamSourceChannel.TrailersHandler(){

            @Override
            public void handleTrailers(HeaderMap headerMap) {
                exchange.putAttachment(HttpAttachments.REQUEST_TRAILERS, headerMap);
            }
        });
        connection.setExchange(exchange);
        dataChannel.setMaxStreamSize(this.maxEntitySize);
        exchange.setRequestScheme(exchange.getRequestHeaders().getFirst(Http2Channel.SCHEME));
        exchange.setRequestMethod(Methods.fromString(exchange.getRequestHeaders().getFirst(Http2Channel.METHOD)));
        exchange.getRequestHeaders().put(Headers.HOST, exchange.getRequestHeaders().getFirst(Http2Channel.AUTHORITY));
        if (!Connectors.areRequestHeadersValid(exchange.getRequestHeaders())) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("Invalid headers in HTTP/2 request, closing connection. Remote peer %s", (Object)connection.getPeerAddress());
            channel.sendGoAway(1);
            return;
        }
        String path = exchange.getRequestHeaders().getFirst(Http2Channel.PATH);
        if (path == null || path.isEmpty()) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("No :path header sent in HTTP/2 request, closing connection. Remote peer %s", (Object)connection.getPeerAddress());
            channel.sendGoAway(1);
            return;
        }
        if (this.recordRequestStartTime) {
            Connectors.setRequestStartTime(exchange);
        }
        this.handleCommonSetup(dataChannel.getResponseChannel(), exchange, connection);
        if (!dataChannel.isOpen()) {
            Connectors.terminateRequest(exchange);
        } else {
            dataChannel.setCompletionListener(new ChannelListener<Http2StreamSourceChannel>(){

                @Override
                public void handleEvent(Http2StreamSourceChannel channel) {
                    Connectors.terminateRequest(exchange);
                }
            });
        }
        if (this.connectorStatistics != null) {
            this.connectorStatistics.setup(exchange);
        }
        try {
            Connectors.setExchangeRequestPath(exchange, path, this.encoding, this.decode, this.slashDecodingFlag, this.decodeBuffer, this.maxParameters);
        }
        catch (ParameterLimitException e) {
            UndertowLogger.REQUEST_IO_LOGGER.debug("Failed to set request path", e);
            exchange.setStatusCode(400);
            exchange.endExchange();
            return;
        }
        exchange.getRequestHeaders().remove(Http2Channel.AUTHORITY);
        exchange.getRequestHeaders().remove(Http2Channel.PATH);
        exchange.getRequestHeaders().remove(Http2Channel.SCHEME);
        exchange.getRequestHeaders().remove(Http2Channel.METHOD);
        Connectors.executeRootHandler(this.rootHandler, exchange);
    }

    void handleInitialRequest(HttpServerExchange initial, Http2Channel channel, byte[] data) {
        Http2HeadersStreamSinkChannel sink = channel.createInitialUpgradeResponseStream();
        Http2ServerConnection connection = new Http2ServerConnection(channel, sink, this.undertowOptions, this.bufferSize, this.rootHandler);
        HeaderMap requestHeaders = new HeaderMap();
        for (HeaderValues hv : initial.getRequestHeaders()) {
            requestHeaders.putAll(hv.getHeaderName(), hv);
        }
        HttpServerExchange exchange = new HttpServerExchange(connection, requestHeaders, sink.getHeaders(), this.maxEntitySize);
        if (initial.getRequestHeaders().contains(Headers.EXPECT)) {
            HttpContinue.markContinueResponseSent(exchange);
        }
        if (initial.getAttachment(HttpAttachments.REQUEST_TRAILERS) != null) {
            exchange.putAttachment(HttpAttachments.REQUEST_TRAILERS, initial.getAttachment(HttpAttachments.REQUEST_TRAILERS));
        }
        Connectors.setRequestStartTime(initial, exchange);
        connection.setExchange(exchange);
        exchange.setRequestScheme(initial.getRequestScheme());
        exchange.setRequestMethod(initial.getRequestMethod());
        exchange.setQueryString(initial.getQueryString());
        if (data != null) {
            Connectors.ungetRequestBytes(exchange, new ImmediatePooledByteBuffer(ByteBuffer.wrap(data)));
        }
        Connectors.terminateRequest(exchange);
        String uri = exchange.getQueryString().isEmpty() ? initial.getRequestURI() : initial.getRequestURI() + '?' + exchange.getQueryString();
        try {
            Connectors.setExchangeRequestPath(exchange, uri, this.encoding, this.decode, this.slashDecodingFlag, this.decodeBuffer, this.maxParameters);
        }
        catch (ParameterLimitException e) {
            exchange.setStatusCode(400);
            exchange.endExchange();
            return;
        }
        this.handleCommonSetup(sink, exchange, connection);
        Connectors.executeRootHandler(this.rootHandler, exchange);
    }

    private void handleCommonSetup(Http2HeadersStreamSinkChannel sink, final HttpServerExchange exchange, Http2ServerConnection connection) {
        Http2Channel channel = (Http2Channel)sink.getChannel();
        SSLSession session = channel.getSslSession();
        if (session != null) {
            connection.setSslSessionInfo(new Http2SslSessionInfo(channel));
        }
        sink.setTrailersProducer(new Http2DataStreamSinkChannel.TrailersProducer(){

            @Override
            public HeaderMap getTrailers() {
                Supplier<HeaderMap> supplier = exchange.getAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER);
                if (supplier != null) {
                    return supplier.get();
                }
                return exchange.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
            }
        });
        sink.setCompletionListener(new ChannelListener<Http2DataStreamSinkChannel>(){

            @Override
            public void handleEvent(Http2DataStreamSinkChannel channel) {
                Connectors.terminateResponse(exchange);
            }
        });
        exchange.setProtocol(Protocols.HTTP_2_0);
        if (exchange.getRequestMethod().equals(Methods.HEAD)) {
            exchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

                @Override
                public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                    return new HeadStreamSinkConduit(factory.create(), null, true);
                }
            });
        }
    }

    private boolean checkRequestHeaders(HeaderMap headers) {
        if (headers.count(Http2Channel.METHOD) != 1 || headers.contains(Headers.CONNECTION)) {
            return false;
        }
        if (headers.get(Http2Channel.METHOD).contains("CONNECT") ? headers.contains(Http2Channel.SCHEME) || headers.contains(Http2Channel.PATH) || headers.count(Http2Channel.AUTHORITY) != 1 : headers.count(Http2Channel.SCHEME) != 1 || headers.count(Http2Channel.PATH) != 1) {
            return false;
        }
        if (headers.contains(Headers.TE)) {
            for (String value : headers.get(Headers.TE)) {
                if (value.equals("trailers")) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.PATH)) {
            for (Object b : (Object)headers.get(Http2Channel.PATH).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (this.allowUnescapedCharactersInUrl || HttpRequestParser.isTargetCharacterAllowed((char)b)) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.SCHEME)) {
            for (Object b : (Object)headers.get(Http2Channel.SCHEME).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (Connectors.isValidSchemeCharacter((byte)b)) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.AUTHORITY)) {
            for (Object b : (Object)headers.get(Http2Channel.AUTHORITY).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (HttpRequestParser.isTargetCharacterAllowed((char)b)) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.METHOD)) {
            for (Object b : (Object)headers.get(Http2Channel.METHOD).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (Connectors.isValidTokenCharacter((byte)b)) continue;
                return false;
            }
        }
        return true;
    }
}

