/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Attachable;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentList;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ListAttachmentKey;

public abstract class AbstractAttachable
implements Attachable {
    private Map<AttachmentKey<?>, Object> attachments;

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null || this.attachments == null) {
            return null;
        }
        return (T)this.attachments.get(key);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null || this.attachments == null) {
            return Collections.emptyList();
        }
        List list = (List)this.attachments.get(key);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        if (this.attachments == null) {
            this.attachments = this.createAttachmentMap();
        }
        return (T)this.attachments.put(key, value);
    }

    protected Map<AttachmentKey<?>, Object> createAttachmentMap() {
        return new IdentityHashMap(5);
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        if (key == null || this.attachments == null) {
            return null;
        }
        return (T)this.attachments.remove(key);
    }

    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        if (key != null) {
            Map<AttachmentKey<?>, Object> attachments;
            AttachmentList list;
            if (this.attachments == null) {
                this.attachments = this.createAttachmentMap();
            }
            if ((list = (AttachmentList)(attachments = this.attachments).get(key)) == null) {
                AttachmentList<T> newList = new AttachmentList<T>(((ListAttachmentKey)key).getValueClass());
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }
}

