/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.XnioByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.UTF8Output;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;

public abstract class StringReadChannelListener
implements ChannelListener<StreamSourceChannel> {
    private final UTF8Output string = new UTF8Output();
    private final ByteBufferPool bufferPool;

    public StringReadChannelListener(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Deprecated
    public StringReadChannelListener(Pool<ByteBuffer> bufferPool) {
        this.bufferPool = new XnioByteBufferPool(bufferPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int r = 0;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    channel.getReadSetter().set(this);
                    channel.resumeReads();
                    continue;
                }
                if (r == -1) {
                    this.stringDone(this.string.extract());
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                this.string.write(buffer);
            } while (r > 0);
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int r = 0;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    return;
                }
                if (r == -1) {
                    this.stringDone(this.string.extract());
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                this.string.write(buffer);
            } while (r > 0);
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            resource.close();
        }
    }

    protected abstract void stringDone(String var1);

    protected abstract void error(IOException var1);
}

