/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;

public class StringWriteChannelListener
implements ChannelListener<StreamSinkChannel> {
    private final ByteBuffer buffer;

    public StringWriteChannelListener(String string) {
        this(string, Charset.defaultCharset());
    }

    public StringWriteChannelListener(String string, Charset charset) {
        this.buffer = ByteBuffer.wrap(string.getBytes(charset));
    }

    public void setup(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.getWriteSetter().set(this);
                channel.resumeWrites();
            } else {
                this.writeDone(channel);
            }
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    protected void handleError(StreamSinkChannel channel, IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)channel);
    }

    @Override
    public void handleEvent(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.resumeWrites();
                return;
            }
            this.writeDone(channel);
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    protected void writeDone(final StreamSinkChannel channel) {
        try {
            channel.shutdownWrites();
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                    @Override
                    public void handleEvent(StreamSinkChannel o) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }, ChannelListeners.closingChannelExceptionHandler()));
                channel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
    }
}

