/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientRequest;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.UndertowClient;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ssl.UndertowXnioSsl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Protocols;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.client.WebSocketClientHandshake;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.client.WebSocketClientNegotiation;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketVersion;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.extensions.ExtensionHandshake;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Cancellable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.FutureResult;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoFuture;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.http.HttpUpgrade;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.http.RedirectException;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.SslConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.XnioSsl;

public class WebSocketClient {
    public static final String BIND_PROPERTY = "net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.BIND_ADDRESS";
    private static final int MAX_REDIRECTS = Integer.getInteger("net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.max-redirects", 5);

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, bufferPool, optionMap, uri, version, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, null, bufferPool, optionMap, uri, version, clientNegotiation);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, clientNegotiation, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, null, uri, version, clientNegotiation, clientExtensions);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap optionMap, InetSocketAddress bindAddress, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        return WebSocketClient.connectionBuilder(worker, bufferPool, uri).setSsl(ssl).setOptionMap(optionMap).setBindAddress(bindAddress).setVersion(version).setClientNegotiation(clientNegotiation).setClientExtensions(clientExtensions).connect();
    }

    public static ConnectionBuilder connectionBuilder(XnioWorker worker, ByteBufferPool bufferPool, URI uri) {
        return new ConnectionBuilder(worker, bufferPool, uri);
    }

    private WebSocketClient() {
    }

    public static class ConnectionBuilder {
        private final XnioWorker worker;
        private final ByteBufferPool bufferPool;
        private final URI uri;
        private XnioSsl ssl;
        private OptionMap optionMap = OptionMap.EMPTY;
        private InetSocketAddress bindAddress;
        private WebSocketVersion version = WebSocketVersion.V13;
        private WebSocketClientNegotiation clientNegotiation;
        private Set<ExtensionHandshake> clientExtensions;
        private URI proxyUri;
        private XnioSsl proxySsl;

        public ConnectionBuilder(XnioWorker worker, ByteBufferPool bufferPool, URI uri) {
            this.worker = worker;
            this.bufferPool = bufferPool;
            this.uri = uri;
        }

        public XnioWorker getWorker() {
            return this.worker;
        }

        public URI getUri() {
            return this.uri;
        }

        public XnioSsl getSsl() {
            return this.ssl;
        }

        public ConnectionBuilder setSsl(XnioSsl ssl) {
            this.ssl = ssl;
            return this;
        }

        public ByteBufferPool getBufferPool() {
            return this.bufferPool;
        }

        public OptionMap getOptionMap() {
            return this.optionMap;
        }

        public ConnectionBuilder setOptionMap(OptionMap optionMap) {
            this.optionMap = optionMap;
            return this;
        }

        public InetSocketAddress getBindAddress() {
            return this.bindAddress;
        }

        public ConnectionBuilder setBindAddress(InetSocketAddress bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public WebSocketVersion getVersion() {
            return this.version;
        }

        public ConnectionBuilder setVersion(WebSocketVersion version) {
            this.version = version;
            return this;
        }

        public WebSocketClientNegotiation getClientNegotiation() {
            return this.clientNegotiation;
        }

        public ConnectionBuilder setClientNegotiation(WebSocketClientNegotiation clientNegotiation) {
            this.clientNegotiation = clientNegotiation;
            return this;
        }

        public Set<ExtensionHandshake> getClientExtensions() {
            return this.clientExtensions;
        }

        public ConnectionBuilder setClientExtensions(Set<ExtensionHandshake> clientExtensions) {
            this.clientExtensions = clientExtensions;
            return this;
        }

        public URI getProxyUri() {
            return this.proxyUri;
        }

        public ConnectionBuilder setProxyUri(URI proxyUri) {
            this.proxyUri = proxyUri;
            return this;
        }

        public XnioSsl getProxySsl() {
            return this.proxySsl;
        }

        public ConnectionBuilder setProxySsl(XnioSsl proxySsl) {
            this.proxySsl = proxySsl;
            return this;
        }

        public IoFuture<WebSocketChannel> connect() {
            return this.connectImpl(this.uri, new FutureResult<WebSocketChannel>(), 0);
        }

        private IoFuture<WebSocketChannel> connectImpl(final URI uri, final FutureResult<WebSocketChannel> ioFuture, final int redirectCount) {
            URI newUri;
            WebSocketLogger.REQUEST_LOGGER.debugf("Opening websocket connection to %s", (Object)uri);
            String scheme = this.isSecure(uri) ? "https" : "http";
            try {
                newUri = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort() == -1 ? (this.isSecure(uri) ? 443 : 80) : uri.getPort(), uri.getPath().isEmpty() ? "/" : uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            final WebSocketClientHandshake handshake = WebSocketClientHandshake.create(this.version, newUri, this.clientNegotiation, this.clientExtensions);
            Map<String, String> originalHeaders = handshake.createHeaders();
            originalHeaders.put("Host", uri.getHost() + ":" + newUri.getPort());
            final HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> entry : originalHeaders.entrySet()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getValue());
                headers.put(entry.getKey(), list);
            }
            if (this.clientNegotiation != null) {
                this.clientNegotiation.beforeRequest(headers);
            }
            InetSocketAddress toBind = this.bindAddress;
            String sysBind = System.getProperty(WebSocketClient.BIND_PROPERTY);
            if (toBind == null && sysBind != null) {
                toBind = new InetSocketAddress(sysBind, 0);
            }
            if (this.proxyUri != null) {
                UndertowClient.getInstance().connect(new ClientCallback<ClientConnection>(){

                    @Override
                    public void completed(final ClientConnection connection) {
                        int port = uri.getPort() > 0 ? uri.getPort() : (this.isSecure(uri) ? 443 : 80);
                        ClientRequest cr = new ClientRequest().setMethod(Methods.CONNECT).setPath(uri.getHost() + ":" + port).setProtocol(Protocols.HTTP_1_1);
                        cr.getRequestHeaders().put(Headers.HOST, proxyUri.getHost() + ":" + (proxyUri.getPort() > 0 ? proxyUri.getPort() : 80));
                        connection.sendRequest(cr, new ClientCallback<ClientExchange>(){

                            @Override
                            public void completed(ClientExchange result) {
                                result.setResponseListener(new ClientCallback<ClientExchange>(){

                                    @Override
                                    public void completed(ClientExchange response) {
                                        block7: {
                                            try {
                                                if (response.getResponse().getResponseCode() == 200) {
                                                    try {
                                                        StreamConnection targetConnection = connection.performUpgrade();
                                                        WebSocketLogger.REQUEST_LOGGER.debugf("Established websocket connection to %s", (Object)uri);
                                                        if (this.isSecure(uri)) {
                                                            this.handleConnectionWithExistingConnection(((UndertowXnioSsl)ssl).wrapExistingConnection(targetConnection, optionMap, uri));
                                                            break block7;
                                                        }
                                                        this.handleConnectionWithExistingConnection(targetConnection);
                                                    }
                                                    catch (IOException e) {
                                                        ioFuture.setException(e);
                                                    }
                                                    catch (Exception e) {
                                                        ioFuture.setException(new IOException(e));
                                                    }
                                                    break block7;
                                                }
                                                ioFuture.setException(UndertowMessages.MESSAGES.proxyConnectionFailed(response.getResponse().getResponseCode()));
                                            }
                                            catch (Exception e) {
                                                ioFuture.setException(new IOException(e));
                                            }
                                        }
                                    }

                                    private void handleConnectionWithExistingConnection(StreamConnection targetConnection) {
                                        final IoFuture<StreamConnection> result = HttpUpgrade.performUpgrade(targetConnection, newUri, headers, (ChannelListener<? super StreamConnection>)new WebsocketConnectionListener(optionMap, handshake, newUri, ioFuture), handshake.handshakeChecker(newUri, headers));
                                        result.addNotifier(new IoFuture.Notifier<Object, Object>(){

                                            @Override
                                            public void notify(IoFuture<?> res, Object attachment) {
                                                if (res.getStatus() == IoFuture.Status.FAILED) {
                                                    ioFuture.setException(res.getException());
                                                }
                                            }
                                        }, null);
                                        ioFuture.addCancelHandler(new Cancellable(){

                                            @Override
                                            public Cancellable cancel() {
                                                result.cancel();
                                                return null;
                                            }
                                        });
                                    }

                                    @Override
                                    public void failed(IOException e) {
                                        ioFuture.setException(e);
                                    }
                                });
                            }

                            @Override
                            public void failed(IOException e) {
                                ioFuture.setException(e);
                            }
                        });
                    }

                    @Override
                    public void failed(IOException e) {
                        ioFuture.setException(e);
                    }
                }, this.bindAddress, this.proxyUri, this.worker, this.proxySsl, this.bufferPool, this.optionMap);
            } else {
                final IoFuture<StreamConnection> result = this.ssl != null ? HttpUpgrade.performUpgrade(this.worker, this.ssl, toBind, newUri, headers, (ChannelListener<? super SslConnection>)new WebsocketConnectionListener(this.optionMap, handshake, newUri, ioFuture), null, this.optionMap, handshake.handshakeChecker(newUri, headers)) : HttpUpgrade.performUpgrade(this.worker, toBind, newUri, headers, (ChannelListener<? super StreamConnection>)new WebsocketConnectionListener(this.optionMap, handshake, newUri, ioFuture), null, this.optionMap, handshake.handshakeChecker(newUri, headers));
                result.addNotifier(new IoFuture.Notifier<Object, Object>(){

                    @Override
                    public void notify(IoFuture<?> res, Object attachment) {
                        if (res.getStatus() == IoFuture.Status.FAILED) {
                            IOException exception = res.getException();
                            if (exception instanceof RedirectException) {
                                if (redirectCount == MAX_REDIRECTS) {
                                    ioFuture.setException(UndertowMessages.MESSAGES.tooManyRedirects(exception));
                                } else {
                                    String path = ((RedirectException)exception).getLocation();
                                    try {
                                        this.connectImpl(new URI(path), ioFuture, redirectCount + 1);
                                    }
                                    catch (URISyntaxException e) {
                                        ioFuture.setException(new IOException(e));
                                    }
                                }
                            } else {
                                ioFuture.setException(exception);
                            }
                        }
                    }
                }, null);
                ioFuture.addCancelHandler(new Cancellable(){

                    @Override
                    public Cancellable cancel() {
                        result.cancel();
                        return null;
                    }
                });
            }
            return ioFuture.getIoFuture();
        }

        private boolean isSecure(URI uri) {
            return uri.getScheme().equals("wss") || uri.getScheme().equals("https");
        }

        private class WebsocketConnectionListener
        implements ChannelListener<StreamConnection> {
            private final OptionMap options;
            private final WebSocketClientHandshake handshake;
            private final URI newUri;
            private final FutureResult<WebSocketChannel> ioFuture;

            WebsocketConnectionListener(OptionMap options, WebSocketClientHandshake handshake, URI newUri, FutureResult<WebSocketChannel> ioFuture) {
                this.options = options;
                this.handshake = handshake;
                this.newUri = newUri;
                this.ioFuture = ioFuture;
            }

            @Override
            public void handleEvent(StreamConnection channel) {
                WebSocketChannel result = this.handshake.createChannel(channel, this.newUri.toString(), ConnectionBuilder.this.bufferPool, this.options);
                this.ioFuture.setResult(result);
            }
        }
    }
}

