/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.function;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.function.ChannelFunction;

public class ChannelFunctionReadableByteChannel
implements ReadableByteChannel {
    private final ChannelFunction[] functions;
    private final ReadableByteChannel channel;

    public ChannelFunctionReadableByteChannel(ReadableByteChannel channel, ChannelFunction ... functions) {
        this.channel = channel;
        this.functions = functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int pos = dst.position();
        int r = 0;
        try {
            int n = r = this.channel.read(dst);
            return n;
        }
        finally {
            if (r > 0) {
                for (ChannelFunction func : this.functions) {
                    func.afterRead(dst, pos, r);
                }
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

