/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.function;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.function.ChannelFunction;

public class ChannelFunctionWritableByteChannel
implements WritableByteChannel {
    private final ChannelFunction[] functions;
    private final WritableByteChannel channel;

    public ChannelFunctionWritableByteChannel(WritableByteChannel channel, ChannelFunction ... functions) {
        this.channel = channel;
        this.functions = functions;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        for (ChannelFunction func : this.functions) {
            int pos = src.position();
            func.beforeWrite(src, pos, src.limit() - pos);
        }
        return this.channel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

