/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.spi;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.IoCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.Sender;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.SecurityContext;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.idm.Account;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpUpgradeListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.session.SessionConfig;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.session.SessionManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.spi.WebSocketHttpExchange;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.FinishedIoFuture;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.FutureResult;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoFuture;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;

public class AsyncWebSocketHttpServerExchange
implements WebSocketHttpExchange {
    private final HttpServerExchange exchange;
    private Sender sender;
    private final Set<WebSocketChannel> peerConnections;

    public AsyncWebSocketHttpServerExchange(HttpServerExchange exchange, Set<WebSocketChannel> peerConnections) {
        this.exchange = exchange;
        this.peerConnections = peerConnections;
    }

    @Override
    public <T> void putAttachment(AttachmentKey<T> key, T value) {
        this.exchange.putAttachment(key, value);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return this.exchange.getAttachment(key);
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.exchange.getRequestHeaders().getFirst(HttpString.tryFromString(headerName));
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        TreeMap<String, ArrayList<String>> headers = new TreeMap<String, ArrayList<String>>(String.CASE_INSENSITIVE_ORDER);
        for (HttpString header : this.exchange.getRequestHeaders().getHeaderNames()) {
            headers.put(header.toString(), new ArrayList<String>(this.exchange.getRequestHeaders().get(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.exchange.getResponseHeaders().getFirst(HttpString.tryFromString(headerName));
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (HttpString header : this.exchange.getResponseHeaders().getHeaderNames()) {
            headers.put(header.toString(), new ArrayList<String>(this.exchange.getResponseHeaders().get(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        HeaderMap map = this.exchange.getRequestHeaders();
        map.clear();
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            map.addAll(HttpString.tryFromString(header.getKey()), (Collection<String>)header.getValue());
        }
    }

    @Override
    public void setResponseHeader(String headerName, String headerValue) {
        this.exchange.getResponseHeaders().put(HttpString.tryFromString(headerName), headerValue);
    }

    @Override
    public void upgradeChannel(HttpUpgradeListener upgradeCallback) {
        this.exchange.upgradeChannel(upgradeCallback);
    }

    @Override
    public IoFuture<Void> sendData(ByteBuffer data) {
        if (this.sender == null) {
            this.sender = this.exchange.getResponseSender();
        }
        final FutureResult future = new FutureResult();
        this.sender.send(data, new IoCallback(){

            @Override
            public void onComplete(HttpServerExchange exchange, Sender sender) {
                future.setResult(null);
            }

            @Override
            public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                future.setException(exception);
            }
        });
        return future.getIoFuture();
    }

    @Override
    public IoFuture<byte[]> readRequestData() {
        final ByteArrayOutputStream data = new ByteArrayOutputStream();
        PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        final ByteBuffer buffer = pooled.getBuffer();
        StreamSourceChannel channel = this.exchange.getRequestChannel();
        try {
            while (true) {
                int res;
                if ((res = channel.read(buffer)) == -1) {
                    return new FinishedIoFuture<byte[]>(data.toByteArray());
                }
                if (res == 0) {
                    final FutureResult future = new FutureResult();
                    channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                        @Override
                        public void handleEvent(StreamSourceChannel channel) {
                            try {
                                int res = channel.read(buffer);
                                if (res == -1) {
                                    future.setResult(data.toByteArray());
                                    channel.suspendReads();
                                    return;
                                }
                                if (res == 0) {
                                    return;
                                }
                                buffer.flip();
                                while (buffer.hasRemaining()) {
                                    data.write(buffer.get());
                                }
                                buffer.clear();
                            }
                            catch (IOException e) {
                                future.setException(e);
                            }
                        }
                    });
                    channel.resumeReads();
                    return future.getIoFuture();
                }
                buffer.flip();
                while (buffer.hasRemaining()) {
                    data.write(buffer.get());
                }
                buffer.clear();
            }
        }
        catch (IOException e) {
            FutureResult future = new FutureResult();
            future.setException(e);
            return future.getIoFuture();
        }
    }

    @Override
    public void endExchange() {
        this.exchange.endExchange();
    }

    @Override
    public void close() {
        try {
            this.exchange.endExchange();
        }
        finally {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
        }
    }

    @Override
    public String getRequestScheme() {
        return this.exchange.getRequestScheme();
    }

    @Override
    public String getRequestURI() {
        String q = this.exchange.getQueryString();
        if (q == null || q.isEmpty()) {
            return this.exchange.getRequestURI();
        }
        return this.exchange.getRequestURI() + "?" + q;
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.exchange.getConnection().getByteBufferPool();
    }

    @Override
    public String getQueryString() {
        return this.exchange.getQueryString();
    }

    @Override
    public Object getSession() {
        SessionManager sm = this.exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
        SessionConfig sessionCookieConfig = this.exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
        if (sm != null && sessionCookieConfig != null) {
            return sm.getSession(this.exchange, sessionCookieConfig);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getRequestParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (Map.Entry<String, Deque<String>> param : this.exchange.getQueryParameters().entrySet()) {
            params.put(param.getKey(), new ArrayList(param.getValue()));
        }
        return params;
    }

    @Override
    public Principal getUserPrincipal() {
        SecurityContext sc = this.exchange.getSecurityContext();
        if (sc == null) {
            return null;
        }
        Account authenticatedAccount = sc.getAuthenticatedAccount();
        if (authenticatedAccount == null) {
            return null;
        }
        return authenticatedAccount.getPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        SecurityContext sc = this.exchange.getSecurityContext();
        if (sc == null) {
            return false;
        }
        Account authenticatedAccount = sc.getAuthenticatedAccount();
        if (authenticatedAccount == null) {
            return false;
        }
        return authenticatedAccount.getRoles().contains(role);
    }

    @Override
    public Set<WebSocketChannel> getPeerConnections() {
        return this.peerConnections;
    }

    @Override
    public OptionMap getOptions() {
        return this.exchange.getConnection().getUndertowOptions();
    }
}

