/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.spi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.FinishedIoFuture;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.FutureResult;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoFuture;

public class BlockingWebSocketHttpServerExchange
extends AsyncWebSocketHttpServerExchange {
    private final OutputStream out;
    private final InputStream in;

    public BlockingWebSocketHttpServerExchange(HttpServerExchange exchange, Set<WebSocketChannel> peerConnections) {
        super(exchange, peerConnections);
        this.out = exchange.getOutputStream();
        this.in = exchange.getInputStream();
    }

    @Override
    public IoFuture<Void> sendData(ByteBuffer data) {
        try {
            while (data.hasRemaining()) {
                this.out.write(data.get());
            }
            return new FinishedIoFuture<Object>(null);
        }
        catch (IOException e) {
            FutureResult ioFuture = new FutureResult();
            ioFuture.setException(e);
            return ioFuture.getIoFuture();
        }
    }

    @Override
    public IoFuture<byte[]> readRequestData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int r;
            byte[] buf = new byte[1024];
            while ((r = this.in.read(buf)) != -1) {
                data.write(buf, 0, r);
            }
            return new FinishedIoFuture<byte[]>(data.toByteArray());
        }
        catch (IOException e) {
            FutureResult ioFuture = new FutureResult();
            ioFuture.setException(e);
            return ioFuture.getIoFuture();
        }
    }
}

