/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.CompileException;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.Cookable;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.ErrorHandler;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.IClassBodyEvaluator;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.InternalCompilerException;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.Location;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.WarningHandler;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.nullanalysis.Nullable;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.JaninoOption;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.Java;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.Parser;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.Scanner;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.SimpleCompiler;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.TokenType;

public class ClassBodyEvaluator
extends Cookable
implements IClassBodyEvaluator {
    private static final Class<?>[] ZERO_CLASSES = new Class[0];
    @Nullable
    private WarningHandler warningHandler;
    private final SimpleCompiler sc = new SimpleCompiler();
    private String[] defaultImports = new String[0];
    private int sourceVersion = -1;
    private String className = "SC";
    @Nullable
    private Class<?> extendedType;
    private Class<?>[] implementedTypes = ZERO_CLASSES;
    @Nullable
    private Class<?> result;

    public ClassBodyEvaluator(String classBody) throws CompileException {
        this.cook(classBody);
    }

    public ClassBodyEvaluator(@Nullable String fileName, InputStream is) throws CompileException, IOException {
        this.cook(fileName, is);
    }

    public ClassBodyEvaluator(@Nullable String fileName, Reader reader) throws CompileException, IOException {
        this.cook(fileName, reader);
    }

    public ClassBodyEvaluator(Scanner scanner, @Nullable ClassLoader parentClassLoader) throws CompileException, IOException {
        this.setParentClassLoader(parentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator(Scanner scanner, @Nullable Class<?> extendedType, Class<?>[] implementedTypes, @Nullable ClassLoader parentClassLoader) throws CompileException, IOException {
        this.setExtendedClass(extendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setParentClassLoader(parentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator(Scanner scanner, String className, @Nullable Class<?> extendedType, Class<?>[] implementedTypes, @Nullable ClassLoader parentClassLoader) throws CompileException, IOException {
        this.setClassName(className);
        this.setExtendedClass(extendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setParentClassLoader(parentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator() {
    }

    @Override
    public void setDefaultImports(String ... defaultImports) {
        this.defaultImports = (String[])defaultImports.clone();
    }

    @Override
    public String[] getDefaultImports() {
        return (String[])this.defaultImports.clone();
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void setExtendedClass(@Nullable Class<?> extendedType) {
        this.extendedType = extendedType;
    }

    @Override
    public void setExtendedType(@Nullable Class<?> extendedClass) {
        this.setExtendedClass(extendedClass);
    }

    @Override
    public void setImplementedInterfaces(Class<?>[] implementedTypes) {
        this.implementedTypes = implementedTypes;
    }

    @Override
    public void setImplementedTypes(Class<?>[] implementedInterfaces) {
        this.setImplementedInterfaces(implementedInterfaces);
    }

    @Override
    public void setParentClassLoader(@Nullable ClassLoader parentClassLoader) {
        this.sc.setParentClassLoader(parentClassLoader);
    }

    @Override
    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.sc.setDebuggingInformation(debugSource, debugLines, debugVars);
    }

    @Override
    public void setSourceVersion(int version) {
        this.sc.setSourceVersion(version);
        this.sourceVersion = version;
    }

    @Override
    public void setTargetVersion(int version) {
        this.sc.setTargetVersion(version);
    }

    @Override
    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.sc.setCompileErrorHandler(compileErrorHandler);
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.sc.setWarningHandler(warningHandler);
        this.warningHandler = warningHandler;
    }

    public EnumSet<JaninoOption> options() {
        return this.sc.options();
    }

    public ClassBodyEvaluator options(EnumSet<JaninoOption> options) {
        this.sc.options(options);
        return this;
    }

    @Override
    public final void cook(@Nullable String fileName, Reader r) throws CompileException, IOException {
        this.cook(new Scanner(fileName, r));
    }

    public void cook(Scanner scanner) throws CompileException, IOException {
        try {
            this.cook2(scanner);
        }
        catch (StackOverflowError soe) {
            throw new CompileException("Script is nested too deeply", null, soe);
        }
    }

    private void cook2(Scanner scanner) throws CompileException, IOException {
        Parser parser = new Parser(scanner);
        parser.setSourceVersion(this.sourceVersion);
        Java.AbstractCompilationUnit.ImportDeclaration[] importDeclarations = this.makeImportDeclarations(parser);
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(scanner.getFileName(), importDeclarations);
        Java.PackageMemberClassDeclaration acd = this.addPackageMemberClassDeclaration(scanner.location(), compilationUnit);
        while (!parser.peek(TokenType.END_OF_INPUT)) {
            parser.parseClassBodyDeclaration(acd);
        }
        this.cook(compilationUnit);
    }

    void cook(Java.CompilationUnit compilationUnit) throws CompileException {
        Class<?> c;
        this.sc.cook(compilationUnit);
        try {
            c = this.sc.getClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            throw new InternalCompilerException("SNO: Generated compilation unit does not declare class '" + this.className + "'", ex);
        }
        this.result = c;
    }

    @Override
    public Class<?> getClazz() {
        return this.assertCooked();
    }

    @Override
    public Map<String, byte[]> getBytecodes() {
        return this.sc.getBytecodes();
    }

    final Java.AbstractCompilationUnit.ImportDeclaration[] makeImportDeclarations(@Nullable Parser parser) throws CompileException, IOException {
        ArrayList<Java.AbstractCompilationUnit.ImportDeclaration> l = new ArrayList<Java.AbstractCompilationUnit.ImportDeclaration>();
        for (String defaultImport : this.defaultImports) {
            Parser p = new Parser(new Scanner(null, new StringReader(defaultImport)));
            p.setSourceVersion(this.sourceVersion);
            p.setWarningHandler(this.warningHandler);
            l.add(p.parseImportDeclarationBody());
            p.read(TokenType.END_OF_INPUT);
        }
        if (parser != null) {
            while (parser.peek("import")) {
                l.add(parser.parseImportDeclaration());
            }
        }
        return l.toArray(new Java.AbstractCompilationUnit.ImportDeclaration[l.size()]);
    }

    protected Java.PackageMemberClassDeclaration addPackageMemberClassDeclaration(Location location, Java.CompilationUnit compilationUnit) {
        String cn = this.className;
        int idx = cn.lastIndexOf(46);
        if (idx != -1) {
            compilationUnit.setPackageDeclaration(new Java.PackageDeclaration(location, cn.substring(0, idx)));
            cn = cn.substring(idx + 1);
        }
        Java.PackageMemberClassDeclaration tlcd = new Java.PackageMemberClassDeclaration(location, null, new Java.Modifier[]{new Java.AccessModifier("public", location)}, cn, null, this.optionalClassToType(location, this.extendedType), this.sc.classesToTypes(location, this.implementedTypes));
        compilationUnit.addPackageMemberTypeDeclaration(tlcd);
        return tlcd;
    }

    @Nullable
    protected Java.Type optionalClassToType(Location location, @Nullable Class<?> clazz) {
        return this.sc.optionalClassToType(location, clazz);
    }

    protected Java.Type classToType(Location location, Class<?> clazz) {
        return this.sc.classToType(location, clazz);
    }

    public Java.Type[] classesToTypes(Location location, Class<?>[] classes) {
        return this.sc.classesToTypes(location, classes);
    }

    private Class<?> assertCooked() {
        if (this.result != null) {
            return this.result;
        }
        throw new IllegalStateException("Must only be called after 'cook()'");
    }

    @Override
    public Object createInstance(Reader reader) throws CompileException, IOException {
        this.cook(reader);
        try {
            return this.getClazz().newInstance();
        }
        catch (InstantiationException ie) {
            CompileException ce = new CompileException("Class is abstract, an interface, an array class, a primitive type, or void; or has no zero-parameter constructor", null);
            ce.initCause(ie);
            throw ce;
        }
        catch (IllegalAccessException iae) {
            CompileException ce = new CompileException("The class or its zero-parameter constructor is not accessible", null);
            ce.initCause(iae);
            throw ce;
        }
    }

    @Deprecated
    public static Object createFastClassBodyEvaluator(Scanner scanner, @Nullable Class<?> baseType, @Nullable ClassLoader parentClassLoader) throws CompileException, IOException {
        Class[] classArray;
        Class<?> clazz = baseType != null && !baseType.isInterface() ? baseType : null;
        if (baseType != null && baseType.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = baseType;
        } else {
            classArray = new Class[]{};
        }
        return ClassBodyEvaluator.createFastClassBodyEvaluator(scanner, "SC", clazz, classArray, parentClassLoader);
    }

    @Deprecated
    public static Object createFastClassBodyEvaluator(Scanner scanner, String className, @Nullable Class<?> extendedClass, Class<?>[] implementedInterfaces, @Nullable ClassLoader parentClassLoader) throws CompileException, IOException {
        ClassBodyEvaluator cbe = new ClassBodyEvaluator();
        cbe.setClassName(className);
        cbe.setExtendedClass(extendedClass);
        cbe.setImplementedInterfaces(implementedInterfaces);
        cbe.setParentClassLoader(parentClassLoader);
        cbe.cook(scanner);
        Class<?> c = cbe.getClazz();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new CompileException(e.getMessage(), null);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerException(e.toString(), e);
        }
    }
}

