/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.validationcontext;

import java.util.Objects;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.ConstraintValidatorFactory;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.ConstraintViolation;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.Path;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.TraversableResolver;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.metadata.ConstraintDescriptor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.validationcontext.AbstractValidationContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.validationcontext.ValidatorScopedContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.valuecontext.ValueContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.core.MetaConstraint;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.location.AbstractPropertyConstraintLocation;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.location.TypeArgumentConstraintLocation;

class PropertyValidationContext<T>
extends AbstractValidationContext<T> {
    private String validatedProperty;

    PropertyValidationContext(ConstraintValidatorManager constraintValidatorManager, ConstraintValidatorFactory constraintValidatorFactory, ValidatorScopedContext validatorScopedContext, TraversableResolver traversableResolver, HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext, T rootBean, Class<T> rootBeanClass, BeanMetaData<T> rootBeanMetaData, String validatedProperty) {
        super(constraintValidatorManager, constraintValidatorFactory, validatorScopedContext, traversableResolver, constraintValidatorInitializationContext, rootBean, rootBeanClass, rootBeanMetaData, PropertyValidationContext.buildDisableAlreadyValidatedBeanTracking(rootBeanMetaData));
        this.validatedProperty = validatedProperty;
    }

    private static boolean buildDisableAlreadyValidatedBeanTracking(BeanMetaData<?> rootBeanMetaData) {
        return !rootBeanMetaData.hasCascadables();
    }

    @Override
    public boolean appliesTo(MetaConstraint<?> metaConstraint) {
        return Objects.equals(this.validatedProperty, this.getPropertyName(metaConstraint.getLocation()));
    }

    private String getPropertyName(ConstraintLocation location) {
        if (location instanceof TypeArgumentConstraintLocation) {
            location = ((TypeArgumentConstraintLocation)location).getOuterDelegate();
        }
        if (location instanceof AbstractPropertyConstraintLocation) {
            return ((AbstractPropertyConstraintLocation)location).getPropertyName();
        }
        return null;
    }

    @Override
    protected ConstraintViolation<T> createConstraintViolation(String messageTemplate, String interpolatedMessage, Path propertyPath, ConstraintDescriptor<?> constraintDescriptor, ValueContext<?, ?> localContext, ConstraintViolationCreationContext constraintViolationCreationContext) {
        return ConstraintViolationImpl.forBeanValidation(messageTemplate, constraintViolationCreationContext.getMessageParameters(), constraintViolationCreationContext.getExpressionVariables(), interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), propertyPath, constraintDescriptor, constraintViolationCreationContext.getDynamicPayload());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('{');
        sb.append("rootBeanClass=").append(this.getRootBeanClass());
        sb.append(", validatedProperty='").append(this.validatedProperty).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

