/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.valueextraction;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.ValidationException;
import net.thisptr.jmx.exporter.agent.shade.jakarta.validation.valueextraction.ValueExtractor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValueExtractorHelper {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private ValueExtractorHelper() {
    }

    public static Set<Class<? extends ValueExtractor>> toValueExtractorClasses(Set<ValueExtractorDescriptor> valueExtractorDescriptors) {
        return valueExtractorDescriptors.stream().map(valueExtractorDescriptor -> valueExtractorDescriptor.getValueExtractor().getClass()).collect(Collectors.toSet());
    }

    public static void extractValues(ValueExtractorDescriptor valueExtractorDescriptor, Object containerValue, ValueExtractor.ValueReceiver valueReceiver) {
        ValueExtractor<?> valueExtractor = valueExtractorDescriptor.getValueExtractor();
        try {
            valueExtractor.extractValues(containerValue, valueReceiver);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw LOG.getErrorWhileExtractingValuesInValueExtractorException(valueExtractor.getClass(), e);
        }
    }
}

