/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

enum BuiltinConstraint {
    JAKARTA_VALIDATION_CONSTRAINTS_ASSERT_FALSE("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.AssertFalse"),
    JAKARTA_VALIDATION_CONSTRAINTS_ASSERT_TRUE("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.AssertTrue"),
    JAKARTA_VALIDATION_CONSTRAINTS_DECIMAL_MAX("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.DecimalMax"),
    JAKARTA_VALIDATION_CONSTRAINTS_DECIMAL_MIN("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.DecimalMin"),
    JAKARTA_VALIDATION_CONSTRAINTS_DIGITS("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Digits"),
    JAKARTA_VALIDATION_CONSTRAINTS_EMAIL("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Email"),
    JAKARTA_VALIDATION_CONSTRAINTS_FUTURE("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Future"),
    JAKARTA_VALIDATION_CONSTRAINTS_FUTURE_OR_PRESENT("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.FutureOrPresent"),
    JAKARTA_VALIDATION_CONSTRAINTS_MIN("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Min"),
    JAKARTA_VALIDATION_CONSTRAINTS_MAX("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Max"),
    JAKARTA_VALIDATION_CONSTRAINTS_NEGATIVE("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Negative"),
    JAKARTA_VALIDATION_CONSTRAINTS_NEGATIVE_OR_ZERO("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.NegativeOrZero"),
    JAKARTA_VALIDATION_CONSTRAINTS_NOT_BLANK("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.NotBlank"),
    JAKARTA_VALIDATION_CONSTRAINTS_NOT_EMPTY("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.NotEmpty"),
    JAKARTA_VALIDATION_CONSTRAINTS_NOT_NULL("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.NotNull"),
    JAKARTA_VALIDATION_CONSTRAINTS_NULL("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Null"),
    JAKARTA_VALIDATION_CONSTRAINTS_PAST("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Past"),
    JAKARTA_VALIDATION_CONSTRAINTS_PAST_OR_PRESENT("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.PastOrPresent"),
    JAKARTA_VALIDATION_CONSTRAINTS_PATTERN("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Pattern"),
    JAKARTA_VALIDATION_CONSTRAINTS_POSITIVE("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Positive"),
    JAKARTA_VALIDATION_CONSTRAINTS_POSITIVE_OR_ZERO("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.PositiveOrZero"),
    JAKARTA_VALIDATION_CONSTRAINTS_SIZE("net.thisptr.jmx.exporter.agent.shade.jakarta.validation.constraints.Size"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_CODE_POINT_LENGTH("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.CodePointLength"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_CURRENCY("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Currency"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_EMAIL("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Email", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_ISBN("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.ISBN"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_LENGTH("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Length"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_LUHN_CHECK("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.LuhnCheck"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_CREDIT_CARD_NUMBER("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.CreditCardNumber", Arrays.asList(ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_LUHN_CHECK)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD10_CHECK("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Mod10Check"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD11_CHECK("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Mod11Check"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD_CHECK("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.ModCheck"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_NORMALIZED("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Normalized"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_EAN("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.EAN", Arrays.asList(ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD10_CHECK)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_NOT_BLANK("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.NotBlank", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_NOT_NULL)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_NOT_EMPTY("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.NotEmpty", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_NOT_NULL, JAKARTA_VALIDATION_CONSTRAINTS_SIZE)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PARAMETER_SCRIPT_ASSERT("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.ParameterScriptAssert"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_RANGE("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Range", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_MIN, JAKARTA_VALIDATION_CONSTRAINTS_MAX)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_SCRIPT_ASSERT("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.ScriptAssert"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_URL("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.URL", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_UNIQUE_ELEMENTS("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.UniqueElements"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_BR_CNPJ("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.br.CNPJ", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_BR_CPF("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.br.CPF", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_PATTERN)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_BR_TITULO_ELEITORAL("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.br.TituloEleitoral", Arrays.asList(JAKARTA_VALIDATION_CONSTRAINTS_PATTERN, ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_MOD11_CHECK)),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PL_NIP("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.pl.NIP"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PL_PESEL("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.pl.PESEL"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_PL_REGON("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.pl.REGON"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_RU_INN("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.ru.INN"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_TIME_DURATION_MAX("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.time.DurationMax"),
    ORG_HIBERNATE_VALIDATOR_CONSTRAINTS_TIME_DURATION_MIN("net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.time.DurationMin");

    private static final Map<String, Set<BuiltinConstraint>> CONSTRAINT_MAPPING;
    private String annotationClassName;
    private List<BuiltinConstraint> constraintDependencies;

    private BuiltinConstraint(String constraint) {
        this(constraint, Collections.emptyList());
    }

    private BuiltinConstraint(String constraint, List<BuiltinConstraint> composingConstraints) {
        this.annotationClassName = constraint;
        this.constraintDependencies = composingConstraints;
    }

    static Set<BuiltinConstraint> resolve(Set<String> constraints) {
        HashSet<BuiltinConstraint> resolvedConstraints = new HashSet<BuiltinConstraint>();
        for (String constraint : constraints) {
            Set<BuiltinConstraint> builtinConstraints = CONSTRAINT_MAPPING.get(constraint);
            if (builtinConstraints == null) continue;
            resolvedConstraints.addAll(builtinConstraints);
        }
        return resolvedConstraints;
    }

    static boolean isBuiltin(String constraint) {
        return CONSTRAINT_MAPPING.containsKey(constraint);
    }

    static Set<String> set() {
        return CONSTRAINT_MAPPING.keySet();
    }

    static {
        CONSTRAINT_MAPPING = new HashMap<String, Set<BuiltinConstraint>>();
        for (BuiltinConstraint constraint : BuiltinConstraint.values()) {
            if (constraint.constraintDependencies.isEmpty()) {
                CONSTRAINT_MAPPING.put(constraint.annotationClassName, Collections.singleton(constraint));
                continue;
            }
            HashSet<BuiltinConstraint> constraints = new HashSet<BuiltinConstraint>();
            constraints.add(constraint);
            constraints.addAll(constraint.constraintDependencies);
            CONSTRAINT_MAPPING.put(constraint.annotationClassName, constraints);
        }
    }
}

