/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.provider;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ConstraintCreationContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.CollectionHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.xml.mapping.MappingXmlParser;

public class XmlMetaDataProvider
implements MetaDataProvider {
    private final Map<String, BeanConfiguration<?>> configuredBeans;
    private final AnnotationProcessingOptions annotationProcessingOptions;

    public XmlMetaDataProvider(ConstraintCreationContext constraintCreationContext, JavaBeanHelper javaBeanHelper, Set<InputStream> mappingStreams, ClassLoader externalClassLoader) {
        MappingXmlParser mappingParser = new MappingXmlParser(constraintCreationContext, javaBeanHelper, externalClassLoader);
        mappingParser.parse(mappingStreams);
        this.configuredBeans = CollectionHelper.toImmutableMap(XmlMetaDataProvider.createBeanConfigurations(mappingParser));
        this.annotationProcessingOptions = mappingParser.getAnnotationProcessingOptions();
    }

    private static Map<String, BeanConfiguration<?>> createBeanConfigurations(MappingXmlParser mappingParser) {
        HashMap configuredBeans = new HashMap();
        for (Class<?> clazz : mappingParser.getXmlConfiguredClasses()) {
            Set<ConstrainedElement> constrainedElements = mappingParser.getConstrainedElementsForClass(clazz);
            BeanConfiguration beanConfiguration = new BeanConfiguration(ConfigurationSource.XML, clazz, constrainedElements, mappingParser.getDefaultSequenceForClass(clazz), null);
            configuredBeans.put(clazz.getName(), beanConfiguration);
        }
        return configuredBeans;
    }

    public <T> BeanConfiguration<T> getBeanConfiguration(Class<T> beanClass) {
        return this.configuredBeans.get(beanClass.getName());
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }
}

