/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.IgnoreForbiddenApisErrors;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanConstructor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanExecutable;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanField;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanGetter;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanMethod;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.Contracts;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.Messages;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.privilegedactions.GetMethodFromGetterNameCandidates;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.spi.nodenameprovider.JavaBeanProperty;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.spi.properties.ConstrainableExecutable;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;

public class JavaBeanHelper {
    private final GetterPropertySelectionStrategy getterPropertySelectionStrategy;
    private final PropertyNodeNameProvider propertyNodeNameProvider;

    public JavaBeanHelper(GetterPropertySelectionStrategy getterPropertySelectionStrategy, PropertyNodeNameProvider propertyNodeNameProvider) {
        this.getterPropertySelectionStrategy = getterPropertySelectionStrategy;
        this.propertyNodeNameProvider = propertyNodeNameProvider;
    }

    public GetterPropertySelectionStrategy getGetterPropertySelectionStrategy() {
        return this.getterPropertySelectionStrategy;
    }

    public PropertyNodeNameProvider getPropertyNodeNameProvider() {
        return this.propertyNodeNameProvider;
    }

    public Optional<JavaBeanField> findDeclaredField(Class<?> declaringClass, String property) {
        Contracts.assertNotNull(declaringClass, Messages.MESSAGES.classCannotBeNull());
        Field field = this.run(GetDeclaredField.action(declaringClass, property));
        return Optional.ofNullable(field).map(this::field);
    }

    public Optional<JavaBeanGetter> findDeclaredGetter(Class<?> declaringClass, String property) {
        Contracts.assertNotNull(declaringClass, Messages.MESSAGES.classCannotBeNull());
        return this.findGetter(declaringClass, property, false);
    }

    public Optional<JavaBeanGetter> findGetter(Class<?> declaringClass, String property) {
        Contracts.assertNotNull(declaringClass, Messages.MESSAGES.classCannotBeNull());
        return this.findGetter(declaringClass, property, true);
    }

    private Optional<JavaBeanGetter> findGetter(Class<?> declaringClass, String property, boolean lookForMethodsOnSuperClass) {
        Method getter = this.run(GetMethodFromGetterNameCandidates.action(declaringClass, this.getterPropertySelectionStrategy.getGetterMethodNameCandidates(property), lookForMethodsOnSuperClass));
        if (getter == null) {
            return Optional.empty();
        }
        return Optional.of(new JavaBeanGetter(declaringClass, getter, property, this.propertyNodeNameProvider.getName(new JavaBeanPropertyImpl(declaringClass, property))));
    }

    public Optional<JavaBeanMethod> findDeclaredMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        Method method = this.run(GetDeclaredMethod.action(declaringClass, methodName, parameterTypes));
        if (method == null) {
            return Optional.empty();
        }
        return Optional.of(this.executable(declaringClass, method));
    }

    public <T> Optional<JavaBeanConstructor> findDeclaredConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        Constructor constructor = (Constructor)this.run(GetDeclaredConstructor.action(declaringClass, parameterTypes));
        if (constructor == null) {
            return Optional.empty();
        }
        return Optional.of(new JavaBeanConstructor(constructor));
    }

    public JavaBeanExecutable<?> executable(Executable executable) {
        return this.executable(executable.getDeclaringClass(), executable);
    }

    public JavaBeanExecutable<?> executable(Class<?> declaringClass, Executable executable) {
        if (executable instanceof Constructor) {
            return new JavaBeanConstructor((Constructor)executable);
        }
        return this.executable(declaringClass, (Method)executable);
    }

    public JavaBeanMethod executable(Class<?> declaringClass, Method method) {
        JavaBeanConstrainableExecutable executable = new JavaBeanConstrainableExecutable(method);
        Optional<String> correspondingProperty = this.getterPropertySelectionStrategy.getProperty(executable);
        if (correspondingProperty.isPresent()) {
            return new JavaBeanGetter(declaringClass, method, correspondingProperty.get(), this.propertyNodeNameProvider.getName(new JavaBeanPropertyImpl(declaringClass, correspondingProperty.get())));
        }
        return new JavaBeanMethod(method);
    }

    public JavaBeanField field(Field field) {
        return new JavaBeanField(field, this.propertyNodeNameProvider.getName(new JavaBeanPropertyImpl(field.getDeclaringClass(), field.getName())));
    }

    @IgnoreForbiddenApisErrors(reason="SecurityManager is deprecated in JDK17")
    private <T> @IgnoreForbiddenApisErrors(reason="SecurityManager is deprecated in JDK17") T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static class JavaBeanPropertyImpl
    implements JavaBeanProperty {
        private final Class<?> declaringClass;
        private final String name;

        private JavaBeanPropertyImpl(Class<?> declaringClass, String name) {
            this.declaringClass = declaringClass;
            this.name = name;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class JavaBeanConstrainableExecutable
    implements ConstrainableExecutable {
        private final Method method;

        private JavaBeanConstrainableExecutable(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }
    }
}

