/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.codec;

import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.codec.Alphabet;

public abstract class Base64Alphabet
extends Alphabet {
    public static final Base64Alphabet STANDARD = new Base64Alphabet(false){

        @Override
        public int encode(int val) {
            if (val <= 25) {
                return 65 + val;
            }
            if (val <= 51) {
                return 97 + val - 26;
            }
            if (val <= 61) {
                return 48 + val - 52;
            }
            if (val == 62) {
                return 43;
            }
            assert (val == 63);
            return 47;
        }

        @Override
        public int decode(int codePoint) throws IllegalArgumentException {
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint - 65;
            }
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 97 + 26;
            }
            if (48 <= codePoint && codePoint <= 57) {
                return codePoint - 48 + 52;
            }
            if (codePoint == 43) {
                return 62;
            }
            if (codePoint == 47) {
                return 63;
            }
            return -1;
        }
    };

    protected Base64Alphabet(boolean littleEndian) {
        super(littleEndian);
    }

    @Override
    public abstract int encode(int var1);

    @Override
    public abstract int decode(int var1);
}

