/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteIterator;

final class ByteBufferIterator
extends ByteIterator {
    private final ByteBuffer buffer;
    private final int initialPosition;

    ByteBufferIterator(ByteBuffer buffer) {
        this.buffer = buffer;
        this.initialPosition = buffer.position();
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasRemaining();
    }

    @Override
    public boolean hasPrevious() {
        return this.buffer.position() > this.initialPosition;
    }

    @Override
    public int next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buffer.get(this.buffer.position()) & 0xFF;
    }

    @Override
    public int previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.buffer.position(this.buffer.position() - 1);
        return this.peekNext();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.buffer.get(this.buffer.position() - 1) & 0xFF;
    }

    @Override
    public long getIndex() {
        return this.buffer.position() - this.initialPosition;
    }
}

