/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteIterator;

final class ConcatByteIterator
extends ByteIterator {
    private final ByteIterator[] iterators;
    private long index = 0L;

    ConcatByteIterator(ByteIterator[] iterators) {
        this.iterators = iterators;
    }

    private int seekNext() {
        for (int i = 0; i < this.iterators.length; ++i) {
            if (!this.iterators[i].hasNext()) continue;
            return i;
        }
        return -1;
    }

    private int seekPrevious() {
        for (int i = this.iterators.length - 1; i >= 0; --i) {
            if (!this.iterators[i].hasPrevious()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        return this.seekNext() != -1;
    }

    @Override
    public boolean hasPrevious() {
        return this.seekPrevious() != -1;
    }

    @Override
    public int next() throws NoSuchElementException {
        int seek = this.seekNext();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        int next = this.iterators[seek].next();
        ++this.index;
        return next;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        int seek = this.seekNext();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        return this.iterators[seek].peekNext();
    }

    @Override
    public int previous() throws NoSuchElementException {
        int seek = this.seekPrevious();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        int previous = this.iterators[seek].previous();
        --this.index;
        return previous;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        int seek = this.seekPrevious();
        if (seek == -1) {
            throw new NoSuchElementException();
        }
        return this.iterators[seek].peekPrevious();
    }

    @Override
    public long getIndex() {
        return this.index;
    }
}

