/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.CodePointIterator;

final class LimitedCodePointIterator
extends CodePointIterator {
    private final CodePointIterator iter;
    private final long size;
    private long offset;

    LimitedCodePointIterator(CodePointIterator iter, long size) {
        this.iter = iter;
        this.size = size;
        this.offset = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.size && this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        return this.iter.next();
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iter.peekNext();
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.offset;
        return this.iter.previous();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.iter.peekPrevious();
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

