/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.Assert;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.bytes.ByteStringBuilder;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.CodePointIterator;

final class Utf8EncodingByteIterator
extends ByteIterator {
    private final CodePointIterator iter;
    private final boolean escapeNul;
    private int st;
    private int cp;
    private long offset;

    Utf8EncodingByteIterator(CodePointIterator iter, boolean escapeNul) {
        this.iter = iter;
        this.escapeNul = escapeNul;
        this.cp = -1;
    }

    @Override
    public boolean hasNext() {
        return this.st != 0 || this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.st != 0 || this.iter.hasPrevious();
    }

    @Override
    public int next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        switch (this.st) {
            case 0: {
                int cp = this.iter.next();
                if (cp == 0 && !this.escapeNul || cp < 128) {
                    return cp;
                }
                if (cp < 2048) {
                    this.cp = cp;
                    this.st = 1;
                    return 0xC0 | cp >> 6;
                }
                if (cp < 65536) {
                    this.cp = cp;
                    this.st = 2;
                    return 0xE0 | cp >> 12;
                }
                if (cp < 0x110000) {
                    this.cp = cp;
                    this.st = 4;
                    return 0xF0 | cp >> 18;
                }
                this.cp = 65533;
                this.st = 2;
                return 239;
            }
            case 1: 
            case 3: 
            case 6: {
                this.st = 0;
                return 0x80 | this.cp & 0x3F;
            }
            case 2: {
                this.st = 3;
                return 0x80 | this.cp >> 6 & 0x3F;
            }
            case 4: {
                this.st = 5;
                return 0x80 | this.cp >> 12 & 0x3F;
            }
            case 5: {
                this.st = 6;
                return 0x80 | this.cp >> 6 & 0x3F;
            }
        }
        throw Assert.impossibleSwitchCase(this.st);
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        switch (this.st) {
            case 0: {
                int cp = this.iter.peekNext();
                if (cp < 128) {
                    return cp;
                }
                if (cp < 2048) {
                    return 0xC0 | cp >> 6;
                }
                if (cp < 65536) {
                    return 0xE0 | cp >> 12;
                }
                if (cp < 0x110000) {
                    return 0xF0 | cp >> 18;
                }
                return 239;
            }
            case 1: 
            case 3: 
            case 6: {
                return 0x80 | this.cp & 0x3F;
            }
            case 2: 
            case 5: {
                return 0x80 | this.cp >> 6 & 0x3F;
            }
            case 4: {
                return 0x80 | this.cp >> 12 & 0x3F;
            }
        }
        throw Assert.impossibleSwitchCase(this.st);
    }

    @Override
    public int previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.offset;
        switch (this.st) {
            case 0: {
                int cp = this.iter.previous();
                if (cp == 0 && !this.escapeNul || cp < 128) {
                    return cp;
                }
                if (cp < 2048) {
                    this.cp = cp;
                    this.st = 1;
                    return 0x80 | cp & 0x3F;
                }
                if (cp < 65536) {
                    this.cp = cp;
                    this.st = 3;
                    return 0x80 | cp & 0x3F;
                }
                if (cp < 0x110000) {
                    this.cp = cp;
                    this.st = 6;
                    return 0x80 | cp & 0x3F;
                }
                this.cp = 65533;
                this.st = 3;
                return 189;
            }
            case 1: {
                this.st = 0;
                return 0xC0 | this.cp >> 6;
            }
            case 2: {
                this.st = 0;
                return 0xE0 | this.cp >> 12;
            }
            case 3: {
                this.st = 2;
                return 0x80 | this.cp >> 6 & 0x3F;
            }
            case 4: {
                this.st = 0;
                return 0xF0 | this.cp >> 18;
            }
            case 5: {
                this.st = 4;
                return 0x80 | this.cp >> 12 & 0x3F;
            }
            case 6: {
                this.st = 5;
                return 0x80 | this.cp >> 6 & 0x3F;
            }
        }
        throw Assert.impossibleSwitchCase(this.st);
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        switch (this.st) {
            case 0: {
                int cp = this.iter.peekPrevious();
                if (cp == 0 && !this.escapeNul || cp < 128) {
                    return cp;
                }
                if (cp < 2048) {
                    return 0x80 | cp & 0x3F;
                }
                if (cp < 65536) {
                    return 0x80 | cp & 0x3F;
                }
                if (cp < 0x110000) {
                    return 0x80 | cp & 0x3F;
                }
                return 189;
            }
            case 1: {
                return 0xC0 | this.cp >> 6;
            }
            case 2: {
                return 0xE0 | this.cp >> 12;
            }
            case 3: 
            case 6: {
                return 0x80 | this.cp >> 6 & 0x3F;
            }
            case 4: {
                return 0xF0 | this.cp >> 18;
            }
            case 5: {
                return 0x80 | this.cp >> 12 & 0x3F;
            }
        }
        throw Assert.impossibleSwitchCase(this.st);
    }

    @Override
    public ByteStringBuilder appendTo(ByteStringBuilder builder) {
        if (this.st == 0) {
            int oldLen = builder.length();
            builder.appendUtf8(this.iter);
            this.offset += (long)(builder.length() - oldLen);
        } else {
            super.appendTo(builder);
        }
        return builder;
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

