/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.channels;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio._private.Messages;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamChannel;

public class BlockingByteChannel
implements ScatteringByteChannel,
GatheringByteChannel,
ByteChannel,
Flushable {
    private final StreamChannel delegate;
    private volatile long readTimeout;
    private volatile long writeTimeout;

    public BlockingByteChannel(StreamChannel delegate) {
        this.delegate = delegate;
    }

    public BlockingByteChannel(StreamChannel delegate, long timeout, TimeUnit timeoutUnit) {
        this(delegate, timeout, timeoutUnit, timeout, timeoutUnit);
    }

    public BlockingByteChannel(StreamChannel delegate, long readTimeout, TimeUnit readTimeoutUnit, long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (readTimeout < 0L) {
            throw Messages.msg.parameterOutOfRange("readTimeout");
        }
        if (writeTimeout < 0L) {
            throw Messages.msg.parameterOutOfRange("writeTimeout");
        }
        long calcReadTimeout = readTimeoutUnit.toNanos(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcReadTimeout < 1L ? 1L : calcReadTimeout);
        long calcWriteTimeout = writeTimeoutUnit.toNanos(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcWriteTimeout < 1L ? 1L : calcWriteTimeout);
        this.delegate = delegate;
    }

    public void setReadTimeout(long readTimeout, TimeUnit readTimeoutUnit) {
        if (readTimeout < 0L) {
            throw Messages.msg.parameterOutOfRange("readTimeout");
        }
        long calcTimeout = readTimeoutUnit.toNanos(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public void setWriteTimeout(long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (writeTimeout < 0L) {
            throw Messages.msg.parameterOutOfRange("writeTimeout");
        }
        long calcTimeout = writeTimeoutUnit.toNanos(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (!Buffers.hasRemaining(dsts, offset, length)) {
            return 0L;
        }
        StreamChannel delegate = this.delegate;
        long res = delegate.read(dsts, offset, length);
        if (res == 0L) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long readTimeout;
                if ((readTimeout = this.readTimeout) == 0L || readTimeout == Long.MAX_VALUE) {
                    delegate.awaitReadable();
                } else {
                    if (readTimeout <= elapsed) {
                        throw Messages.msg.readTimeout();
                    }
                    delegate.awaitReadable(readTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((res = delegate.read(dsts, offset, length)) == 0L);
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!dst.hasRemaining()) {
            return 0;
        }
        StreamChannel delegate = this.delegate;
        int res = delegate.read(dst);
        if (res == 0) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long readTimeout;
                if ((readTimeout = this.readTimeout) == 0L || readTimeout == Long.MAX_VALUE) {
                    delegate.awaitReadable();
                } else {
                    if (readTimeout <= elapsed) {
                        throw Messages.msg.readTimeout();
                    }
                    delegate.awaitReadable(readTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((res = delegate.read(dst)) == 0);
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!Buffers.hasRemaining(srcs, offset, length)) {
            return 0L;
        }
        StreamChannel delegate = this.delegate;
        long res = delegate.write(srcs, offset, length);
        if (res == 0L) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long writeTimeout;
                if ((writeTimeout = this.writeTimeout) == 0L || writeTimeout == Long.MAX_VALUE) {
                    delegate.awaitWritable();
                } else {
                    if (writeTimeout <= elapsed) {
                        throw Messages.msg.writeTimeout();
                    }
                    delegate.awaitWritable(writeTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((res = delegate.write(srcs, offset, length)) == 0L);
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            return 0;
        }
        StreamChannel delegate = this.delegate;
        int res = delegate.write(src);
        if ((long)res == 0L) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long writeTimeout;
                if ((writeTimeout = this.writeTimeout) == 0L || writeTimeout == Long.MAX_VALUE) {
                    delegate.awaitWritable();
                } else {
                    if (writeTimeout <= elapsed) {
                        throw Messages.msg.writeTimeout();
                    }
                    delegate.awaitWritable(writeTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((long)(res = delegate.write(src)) == 0L);
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void flush() throws IOException {
        StreamChannel delegate = this.delegate;
        if (!delegate.flush()) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long writeTimeout;
                if ((writeTimeout = this.writeTimeout) == 0L || writeTimeout == Long.MAX_VALUE) {
                    delegate.awaitWritable();
                } else {
                    if (writeTimeout <= elapsed) {
                        throw Messages.msg.writeTimeout();
                    }
                    delegate.awaitWritable(writeTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while (!delegate.flush());
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

