/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.channels;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio._private.Messages;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;

public class BlockingWritableByteChannel
implements GatheringByteChannel,
Flushable {
    private final StreamSinkChannel delegate;
    private volatile long writeTimeout;

    public BlockingWritableByteChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
    }

    public BlockingWritableByteChannel(StreamSinkChannel delegate, long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (writeTimeout < 0L) {
            throw Messages.msg.parameterOutOfRange("writeTimeout");
        }
        this.delegate = delegate;
        long calcTimeout = writeTimeoutUnit.toNanos(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public void setWriteTimeout(long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (writeTimeout < 0L) {
            throw Messages.msg.parameterOutOfRange("writeTimeout");
        }
        long calcTimeout = writeTimeoutUnit.toNanos(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!Buffers.hasRemaining(srcs, offset, length)) {
            return 0L;
        }
        StreamSinkChannel delegate = this.delegate;
        long res = delegate.write(srcs, offset, length);
        if (res == 0L) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long writeTimeout;
                if ((writeTimeout = this.writeTimeout) == 0L || writeTimeout == Long.MAX_VALUE) {
                    delegate.awaitWritable();
                } else {
                    if (writeTimeout <= elapsed) {
                        throw Messages.msg.writeTimeout();
                    }
                    delegate.awaitWritable(writeTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((res = delegate.write(srcs, offset, length)) == 0L);
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            return 0;
        }
        StreamSinkChannel delegate = this.delegate;
        int res = delegate.write(src);
        if ((long)res == 0L) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long writeTimeout;
                if ((writeTimeout = this.writeTimeout) == 0L || writeTimeout == Long.MAX_VALUE) {
                    delegate.awaitWritable();
                } else {
                    if (writeTimeout <= elapsed) {
                        throw Messages.msg.writeTimeout();
                    }
                    delegate.awaitWritable(writeTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while ((long)(res = delegate.write(src)) == 0L);
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void flush() throws IOException {
        StreamSinkChannel delegate = this.delegate;
        if (!delegate.flush()) {
            long start = System.nanoTime();
            long elapsed = 0L;
            do {
                long writeTimeout;
                if ((writeTimeout = this.writeTimeout) == 0L || writeTimeout == Long.MAX_VALUE) {
                    delegate.awaitWritable();
                } else {
                    if (writeTimeout <= elapsed) {
                        throw Messages.msg.writeTimeout();
                    }
                    delegate.awaitWritable(writeTimeout - elapsed, TimeUnit.NANOSECONDS);
                }
                elapsed = System.nanoTime() - start;
            } while (!delegate.flush());
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

