/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits;

import java.nio.channels.Channel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.CloseListenerSettable;

public interface TerminateHandler {
    public void forceTermination();

    public void terminated();

    public static class ReadyTask
    implements Runnable {
        private final TerminateHandler handler;

        public ReadyTask(TerminateHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.terminated();
        }
    }

    public static class ChannelListenerHandler<C extends Channel & CloseListenerSettable<C>>
    implements TerminateHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

